<?php

namespace Liberty\Services\Inspeccion\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmigenResponse StructType
 * @subpackage Structs
 */
class EmigenResponse extends AbstractStructBase
{
    /**
     * The codigo
     * @var int
     */
    public $codigo;
    /**
     * The descripcion
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descripcion;
    /**
     * Constructor method for EmigenResponse
     * @uses EmigenResponse::setCodigo()
     * @uses EmigenResponse::setDescripcion()
     * @param int $codigo
     * @param string $descripcion
     */
    public function __construct($codigo = null, $descripcion = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \Liberty\Services\Inspeccion\StructType\EmigenResponse
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \Liberty\Services\Inspeccion\StructType\EmigenResponse
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Inspeccion\StructType\EmigenResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
