<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servicios-test.liberty.cl/inspecciongenv-ws/services/ServiceFacade?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servicios-test.liberty.cl/inspecciongenv-ws/services/ServiceFacade?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Liberty\Services\Inspeccion\ClassMap::get(),
);
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \Liberty\Services\Inspeccion\ServiceType\Consultar($options);
/**
 * Sample call for consultar operation/method
 */
if ($consultar->consultar(new \Liberty\Services\Inspeccion\StructType\Consultar()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Samples for Solicitar ServiceType
 */
$solicitar = new \Liberty\Services\Inspeccion\ServiceType\Solicitar($options);
/**
 * Sample call for solicitar operation/method
 */
if ($solicitar->solicitar(new \Liberty\Services\Inspeccion\StructType\Solicitar()) !== false) {
    print_r($solicitar->getResult());
} else {
    print_r($solicitar->getLastError());
}
