<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Vyrobci ServiceType
 * @subpackage Services
 */
class Vyrobci extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Vyrobci
     * Meta informations extracted from the WSDL
     * - documentation: seznam výrobců | seznam výrobců | seznam výrobců
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Vyrobci $parameters
     * @return \StructType\VyrobciResponse|bool
     */
    public function Vyrobci(\StructType\Vyrobci $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Vyrobci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VyrobciResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
