<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ws.atcomp.cz/ciselniky.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ws.atcomp.cz/ciselniky.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Vyrobci ServiceType
 */
$vyrobci = new \ServiceType\Vyrobci($options);
/**
 * Sample call for Vyrobci operation/method
 */
if ($vyrobci->Vyrobci(new \StructType\Vyrobci()) !== false) {
    print_r($vyrobci->getResult());
} else {
    print_r($vyrobci->getLastError());
}
/**
 * Samples for Kategorie ServiceType
 */
$kategorie = new \ServiceType\Kategorie($options);
/**
 * Sample call for Kategorie operation/method
 */
if ($kategorie->Kategorie(new \StructType\Kategorie()) !== false) {
    print_r($kategorie->getResult());
} else {
    print_r($kategorie->getLastError());
}
/**
 * Samples for Podkategorie ServiceType
 */
$podkategorie = new \ServiceType\Podkategorie($options);
/**
 * Sample call for Podkategorie operation/method
 */
if ($podkategorie->Podkategorie(new \StructType\Podkategorie()) !== false) {
    print_r($podkategorie->getResult());
} else {
    print_r($podkategorie->getLastError());
}
/**
 * Samples for Strom ServiceType
 */
$strom = new \ServiceType\Strom($options);
/**
 * Sample call for StromKategoriePodkategorie operation/method
 */
if ($strom->StromKategoriePodkategorie(new \StructType\StromKategoriePodkategorie()) !== false) {
    print_r($strom->getResult());
} else {
    print_r($strom->getLastError());
}
/**
 * Sample call for StromPodleVyrobce operation/method
 */
if ($strom->StromPodleVyrobce(new \StructType\StromPodleVyrobce()) !== false) {
    print_r($strom->getResult());
} else {
    print_r($strom->getLastError());
}
/**
 * Sample call for StromPodleKategorie operation/method
 */
if ($strom->StromPodleKategorie(new \StructType\StromPodleKategorie()) !== false) {
    print_r($strom->getResult());
} else {
    print_r($strom->getLastError());
}
/**
 * Samples for Produkt ServiceType
 */
$produkt = new \ServiceType\Produkt($options);
/**
 * Sample call for ProduktManazeri operation/method
 */
if ($produkt->ProduktManazeri(new \StructType\ProduktManazeri()) !== false) {
    print_r($produkt->getResult());
} else {
    print_r($produkt->getLastError());
}
/**
 * Samples for Zpusoby ServiceType
 */
$zpusoby = new \ServiceType\Zpusoby($options);
/**
 * Sample call for ZpusobyDodavky operation/method
 */
if ($zpusoby->ZpusobyDodavky(new \StructType\ZpusobyDodavky()) !== false) {
    print_r($zpusoby->getResult());
} else {
    print_r($zpusoby->getLastError());
}
/**
 * Samples for Parametry ServiceType
 */
$parametry = new \ServiceType\Parametry($options);
/**
 * Sample call for Parametry operation/method
 */
if ($parametry->Parametry(new \StructType\Parametry()) !== false) {
    print_r($parametry->getResult());
} else {
    print_r($parametry->getLastError());
}
