<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Podkategorie ServiceType
 * @subpackage Services
 */
class Podkategorie extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Podkategorie
     * Meta informations extracted from the WSDL
     * - documentation: seznam ERP kategorií druhé úrovně | seznam ERP kategorií druhé úrovně | seznam ERP kategorií druhé úrovně
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Podkategorie $parameters
     * @return \StructType\PodkategorieResponse|bool
     */
    public function Podkategorie(\StructType\Podkategorie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Podkategorie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PodkategorieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
