<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parametry ServiceType
 * @subpackage Services
 */
class Parametry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Parametry
     * Meta informations extracted from the WSDL
     * - documentation: seznam možných parametrů zboží. typ_parametru: 1 technický, 2 logistický, 3 obchodní. typ_hodnoty: 0 výběrová, 1 intervalová, 2 editovatelná | seznam možných parametrů zboží. typ_parametru: 1 technický, 2
     * logistický, 3 obchodní. typ_hodnoty: 0 výběrová, 1 intervalová, 2 editovatelná | seznam možných parametrů zboží. typ_parametru: 1 technický, 2 logistický, 3 obchodní. typ_hodnoty: 0 výběrová, 1 intervalová, 2 editovatelná
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Parametry $parameters
     * @return \StructType\ParametryResponse|bool
     */
    public function Parametry(\StructType\Parametry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Parametry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ParametryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
