<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kategorie ServiceType
 * @subpackage Services
 */
class Kategorie extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Kategorie
     * Meta informations extracted from the WSDL
     * - documentation: seznam hlavních ERP kategorií | seznam hlavních ERP kategorií | seznam hlavních ERP kategorií
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Kategorie $parameters
     * @return \StructType\KategorieResponse|bool
     */
    public function Kategorie(\StructType\Kategorie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Kategorie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KategorieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
