<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Strom ServiceType
 * @subpackage Services
 */
class Strom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StromKategoriePodkategorie
     * Meta informations extracted from the WSDL
     * - documentation: strom ERP kategorií a podkategorií | strom ERP kategorií a podkategorií | strom ERP kategorií a podkategorií
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StromKategoriePodkategorie $parameters
     * @return \StructType\StromKategoriePodkategorieResponse|bool
     */
    public function StromKategoriePodkategorie(\StructType\StromKategoriePodkategorie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->StromKategoriePodkategorie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StromPodleVyrobce
     * Meta informations extracted from the WSDL
     * - documentation: kategorie a podkategorie daného výrobce | kategorie a podkategorie daného výrobce | kategorie a podkategorie daného výrobce
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StromPodleVyrobce $parameters
     * @return \StructType\StromPodleVyrobceResponse|bool
     */
    public function StromPodleVyrobce(\StructType\StromPodleVyrobce $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->StromPodleVyrobce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StromPodleKategorie
     * Meta informations extracted from the WSDL
     * - documentation: podkategorie a výrobci v dané kategorii | podkategorie a výrobci v dané kategorii | podkategorie a výrobci v dané kategorii
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StromPodleKategorie $parameters
     * @return \StructType\StromPodleKategorieResponse|bool
     */
    public function StromPodleKategorie(\StructType\StromPodleKategorie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->StromPodleKategorie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StromKategoriePodkategorieResponse|\StructType\StromPodleKategorieResponse|\StructType\StromPodleVyrobceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
