<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Produkt ServiceType
 * @subpackage Services
 */
class Produkt extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProduktManazeri
     * Meta informations extracted from the WSDL
     * - documentation: (zrušena) | (zrušena) | (zrušena)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProduktManazeri $parameters
     * @return \StructType\ProduktManazeriResponse|bool
     */
    public function ProduktManazeri(\StructType\ProduktManazeri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProduktManazeri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProduktManazeriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
