<?php

namespace Liberty\Services\Cotizador\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotizador ServiceType
 * @subpackage Services
 */
class Cotizador extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cotizador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Liberty\Services\Cotizador\StructType\Cotizador $parameters
     * @return \Liberty\Services\Cotizador\StructType\CotizadorResponse|bool
     */
    public function cotizador(\Liberty\Services\Cotizador\StructType\Cotizador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cotizador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Liberty\Services\Cotizador\StructType\CotizadorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
