<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Données techniques propres à la requête
 * @subpackage Structs
 */
class RequestContext extends AbstractStructBase
{
    /**
     * The requestId
     * @var string
     */
    public $requestId;
    /**
     * The trackingId
     * Meta informations extracted from the WSDL
     * - documentation: Information permettant le suivi d’une requête de bout en bout en cas d’appel de service imbriqué. - Ne sera pas valorisé lors d'un appel initial à partir d'une application cliente. - Valorisé lorsque l'appel est fait par un
     * webservice, avec l'UUID de la requête initiale (trackingId si présent dans la requête précédente, requestId de la requête précédente sinon).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trackingId;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - documentation: Locale de l'appelant suivant la RFC 3066. Si non renseigné, ce sera la local par défaut du fournisseur de service qui sera utilisée
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for RequestContext
     * @uses RequestContext::setRequestId()
     * @uses RequestContext::setTrackingId()
     * @uses RequestContext::setLanguage()
     * @param string $requestId
     * @param string $trackingId
     * @param string $language
     */
    public function __construct($requestId = null, $trackingId = null, $language = null)
    {
        $this
            ->setRequestId($requestId)
            ->setTrackingId($trackingId)
            ->setLanguage($language);
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\RequestContext
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get trackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }
    /**
     * Set trackingId value
     * @param string $trackingId
     * @return \StructType\RequestContext
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingId)), __LINE__);
        }
        $this->trackingId = $trackingId;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\RequestContext
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
