<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type de contexte technique d'échange qui contient 4 contextes : request, consumer, goal et user
 * @subpackage Structs
 */
class GroupContext extends AbstractStructBase
{
    /**
     * The requestContext
     * @var \StructType\RequestContext
     */
    public $requestContext;
    /**
     * The consumerContext
     * @var \StructType\ConsumerContext
     */
    public $consumerContext;
    /**
     * The goalContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GoalContext
     */
    public $goalContext;
    /**
     * The userContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserContext
     */
    public $userContext;
    /**
     * Constructor method for GroupContext
     * @uses GroupContext::setRequestContext()
     * @uses GroupContext::setConsumerContext()
     * @uses GroupContext::setGoalContext()
     * @uses GroupContext::setUserContext()
     * @param \StructType\RequestContext $requestContext
     * @param \StructType\ConsumerContext $consumerContext
     * @param \StructType\GoalContext $goalContext
     * @param \StructType\UserContext $userContext
     */
    public function __construct(\StructType\RequestContext $requestContext = null, \StructType\ConsumerContext $consumerContext = null, \StructType\GoalContext $goalContext = null, \StructType\UserContext $userContext = null)
    {
        $this
            ->setRequestContext($requestContext)
            ->setConsumerContext($consumerContext)
            ->setGoalContext($goalContext)
            ->setUserContext($userContext);
    }
    /**
     * Get requestContext value
     * @return \StructType\RequestContext|null
     */
    public function getRequestContext()
    {
        return $this->requestContext;
    }
    /**
     * Set requestContext value
     * @param \StructType\RequestContext $requestContext
     * @return \StructType\GroupContext
     */
    public function setRequestContext(\StructType\RequestContext $requestContext = null)
    {
        $this->requestContext = $requestContext;
        return $this;
    }
    /**
     * Get consumerContext value
     * @return \StructType\ConsumerContext|null
     */
    public function getConsumerContext()
    {
        return $this->consumerContext;
    }
    /**
     * Set consumerContext value
     * @param \StructType\ConsumerContext $consumerContext
     * @return \StructType\GroupContext
     */
    public function setConsumerContext(\StructType\ConsumerContext $consumerContext = null)
    {
        $this->consumerContext = $consumerContext;
        return $this;
    }
    /**
     * Get goalContext value
     * @return \StructType\GoalContext|null
     */
    public function getGoalContext()
    {
        return $this->goalContext;
    }
    /**
     * Set goalContext value
     * @param \StructType\GoalContext $goalContext
     * @return \StructType\GroupContext
     */
    public function setGoalContext(\StructType\GoalContext $goalContext = null)
    {
        $this->goalContext = $goalContext;
        return $this;
    }
    /**
     * Get userContext value
     * @return \StructType\UserContext|null
     */
    public function getUserContext()
    {
        return $this->userContext;
    }
    /**
     * Set userContext value
     * @param \StructType\UserContext $userContext
     * @return \StructType\GroupContext
     */
    public function setUserContext(\StructType\UserContext $userContext = null)
    {
        $this->userContext = $userContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
