<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoalContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Données techniques propres à l'environnement du fournisseur de service (application fournissant le WS chez le fournisseur et environnement d'exécution du fournisseur- Utilisé par le fournisseur pour routage dynamique vers WS
 * appelé qui est fonction du context d'exécution de l'application à l'origine du rertoutage vers l'application consommatrice du ws.
 * @subpackage Structs
 */
class GoalContext extends AbstractStructBase
{
    /**
     * The application
     * Meta informations extracted from the WSDL
     * - documentation: Données descriptives de l'application fournissant le WS. Alimentée à partir de données transmises au moment du reroutage vers l'application consommatrice du WS. Utilisé par le fournisseur pour le routage dynamique vers le Ws
     * appelé? QUels infos si plusieurs WS peuvent être appelés?
     * - minOccurs: 0
     * @var \StructType\Application
     */
    public $application;
    /**
     * The run
     * Meta informations extracted from the WSDL
     * - documentation: Données descriptives de l'environnement d'exécution chez le fournisseur de WS. Alimentée à partir de données transmises au moment du reroutage vers l'application consommatrice du WS.Utilisé par le fournisseur pour le routage
     * dynamique vers le Ws appelé.
     * - minOccurs: 0
     * @var \StructType\Run
     */
    public $run;
    /**
     * Constructor method for GoalContext
     * @uses GoalContext::setApplication()
     * @uses GoalContext::setRun()
     * @param \StructType\Application $application
     * @param \StructType\Run $run
     */
    public function __construct(\StructType\Application $application = null, \StructType\Run $run = null)
    {
        $this
            ->setApplication($application)
            ->setRun($run);
    }
    /**
     * Get application value
     * @return \StructType\Application|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param \StructType\Application $application
     * @return \StructType\GoalContext
     */
    public function setApplication(\StructType\Application $application = null)
    {
        $this->application = $application;
        return $this;
    }
    /**
     * Get run value
     * @return \StructType\Run|null
     */
    public function getRun()
    {
        return $this->run;
    }
    /**
     * Set run value
     * @param \StructType\Run $run
     * @return \StructType\GoalContext
     */
    public function setRun(\StructType\Run $run = null)
    {
        $this->run = $run;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GoalContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
