<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumerContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Données techniques propres à l'environnement du consommateur du service (application émettrice de la requête chez le consommateur et environnement d'exécution du consommateur)- essentiellement pour contôle et traces
 * @subpackage Structs
 */
class ConsumerContext extends AbstractStructBase
{
    /**
     * The application
     * Meta informations extracted from the WSDL
     * - documentation: Données descriptives de l'application consommatrice du WS. Aucun contrôle ne peut être fait par le fournisseur de service sur cette information si n'appartient pas à un référentiel groupe. Utilisé par le fournisseur uniquement
     * pour tracage à des fins d'aide au disagnostique inter SI.
     * @var \StructType\Application
     */
    public $application;
    /**
     * The run
     * Meta informations extracted from the WSDL
     * - documentation: Données descriptives de l'environnement d'exécution chez le consommateur de WS. Utilisé par le fournisseur pour tracage à des fins d'aide au diagnostique inter SI et pour routage dynamique.
     * @var \StructType\Run
     */
    public $run;
    /**
     * Constructor method for ConsumerContext
     * @uses ConsumerContext::setApplication()
     * @uses ConsumerContext::setRun()
     * @param \StructType\Application $application
     * @param \StructType\Run $run
     */
    public function __construct(\StructType\Application $application = null, \StructType\Run $run = null)
    {
        $this
            ->setApplication($application)
            ->setRun($run);
    }
    /**
     * Get application value
     * @return \StructType\Application|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param \StructType\Application $application
     * @return \StructType\ConsumerContext
     */
    public function setApplication(\StructType\Application $application = null)
    {
        $this->application = $application;
        return $this;
    }
    /**
     * Get run value
     * @return \StructType\Run|null
     */
    public function getRun()
    {
        return $this->run;
    }
    /**
     * Set run value
     * @param \StructType\Run $run
     * @return \StructType\ConsumerContext
     */
    public function setRun(\StructType\Run $run = null)
    {
        $this->run = $run;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsumerContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
