<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocPersMorl StructType
 * @subpackage Structs
 */
class BlocPersMorl extends AbstractStructBase
{
    /**
     * The NumSIREN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 9
     * @var string
     */
    public $NumSIREN;
    /**
     * The RaisSocl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 64
     * @var string
     */
    public $RaisSocl;
    /**
     * Constructor method for BlocPersMorl
     * @uses BlocPersMorl::setNumSIREN()
     * @uses BlocPersMorl::setRaisSocl()
     * @param string $numSIREN
     * @param string $raisSocl
     */
    public function __construct($numSIREN = null, $raisSocl = null)
    {
        $this
            ->setNumSIREN($numSIREN)
            ->setRaisSocl($raisSocl);
    }
    /**
     * Get NumSIREN value
     * @return string|null
     */
    public function getNumSIREN()
    {
        return $this->NumSIREN;
    }
    /**
     * Set NumSIREN value
     * @param string $numSIREN
     * @return \StructType\BlocPersMorl
     */
    public function setNumSIREN($numSIREN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numSIREN) && strlen($numSIREN) > 9) || (is_array($numSIREN) && count($numSIREN) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($numSIREN) ? strlen($numSIREN) : count($numSIREN)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numSIREN) && !is_string($numSIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numSIREN)), __LINE__);
        }
        $this->NumSIREN = $numSIREN;
        return $this;
    }
    /**
     * Get RaisSocl value
     * @return string|null
     */
    public function getRaisSocl()
    {
        return $this->RaisSocl;
    }
    /**
     * Set RaisSocl value
     * @param string $raisSocl
     * @return \StructType\BlocPersMorl
     */
    public function setRaisSocl($raisSocl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($raisSocl) && strlen($raisSocl) > 64) || (is_array($raisSocl) && count($raisSocl) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($raisSocl) ? strlen($raisSocl) : count($raisSocl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($raisSocl) && !is_string($raisSocl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($raisSocl)), __LINE__);
        }
        $this->RaisSocl = $raisSocl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocPersMorl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
