<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocMoyeComm StructType
 * @subpackage Structs
 */
class BlocMoyeComm extends AbstractStructBase
{
    /**
     * The ListAdrs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BlocAdrs[]
     */
    public $ListAdrs;
    /**
     * The ListMdia
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BlocMdia[]
     */
    public $ListMdia;
    /**
     * The BlocAdrs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BlocAdrs
     */
    public $BlocAdrs;
    /**
     * Constructor method for BlocMoyeComm
     * @uses BlocMoyeComm::setListAdrs()
     * @uses BlocMoyeComm::setListMdia()
     * @uses BlocMoyeComm::setBlocAdrs()
     * @param \StructType\BlocAdrs[] $listAdrs
     * @param \StructType\BlocMdia[] $listMdia
     * @param \StructType\BlocAdrs $blocAdrs
     */
    public function __construct(array $listAdrs = array(), array $listMdia = array(), \StructType\BlocAdrs $blocAdrs = null)
    {
        $this
            ->setListAdrs($listAdrs)
            ->setListMdia($listMdia)
            ->setBlocAdrs($blocAdrs);
    }
    /**
     * Get ListAdrs value
     * @return \StructType\BlocAdrs[]
     */
    public function getListAdrs()
    {
        return $this->ListAdrs;
    }
    /**
     * Set ListAdrs value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocAdrs[] $listAdrs
     * @return \StructType\BlocMoyeComm
     */
    public function setListAdrs(array $listAdrs = array())
    {
        foreach ($listAdrs as $blocMoyeCommListAdrsItem) {
            // validation for constraint: itemType
            if (!$blocMoyeCommListAdrsItem instanceof \StructType\BlocAdrs) {
                throw new \InvalidArgumentException(sprintf('The ListAdrs property can only contain items of \StructType\BlocAdrs, "%s" given', is_object($blocMoyeCommListAdrsItem) ? get_class($blocMoyeCommListAdrsItem) : gettype($blocMoyeCommListAdrsItem)), __LINE__);
            }
        }
        $this->ListAdrs = $listAdrs;
        return $this;
    }
    /**
     * Add item to ListAdrs value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocAdrs $item
     * @return \StructType\BlocMoyeComm
     */
    public function addToListAdrs(\StructType\BlocAdrs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlocAdrs) {
            throw new \InvalidArgumentException(sprintf('The ListAdrs property can only contain items of \StructType\BlocAdrs, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListAdrs[] = $item;
        return $this;
    }
    /**
     * Get ListMdia value
     * @return \StructType\BlocMdia[]
     */
    public function getListMdia()
    {
        return $this->ListMdia;
    }
    /**
     * Set ListMdia value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocMdia[] $listMdia
     * @return \StructType\BlocMoyeComm
     */
    public function setListMdia(array $listMdia = array())
    {
        foreach ($listMdia as $blocMoyeCommListMdiaItem) {
            // validation for constraint: itemType
            if (!$blocMoyeCommListMdiaItem instanceof \StructType\BlocMdia) {
                throw new \InvalidArgumentException(sprintf('The ListMdia property can only contain items of \StructType\BlocMdia, "%s" given', is_object($blocMoyeCommListMdiaItem) ? get_class($blocMoyeCommListMdiaItem) : gettype($blocMoyeCommListMdiaItem)), __LINE__);
            }
        }
        $this->ListMdia = $listMdia;
        return $this;
    }
    /**
     * Add item to ListMdia value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocMdia $item
     * @return \StructType\BlocMoyeComm
     */
    public function addToListMdia(\StructType\BlocMdia $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlocMdia) {
            throw new \InvalidArgumentException(sprintf('The ListMdia property can only contain items of \StructType\BlocMdia, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListMdia[] = $item;
        return $this;
    }
    /**
     * Get BlocAdrs value
     * @return \StructType\BlocAdrs
     */
    public function getBlocAdrs()
    {
        return $this->BlocAdrs;
    }
    /**
     * Set BlocAdrs value
     * @param \StructType\BlocAdrs $blocAdrs
     * @return \StructType\BlocMoyeComm
     */
    public function setBlocAdrs(\StructType\BlocAdrs $blocAdrs = null)
    {
        $this->BlocAdrs = $blocAdrs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocMoyeComm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
