<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocIdTiers StructType
 * @subpackage Structs
 */
class BlocIdTiers extends AbstractStructBase
{
    /**
     * The CdEtabFinnTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 5
     * @var string
     */
    public $CdEtabFinnTier;
    /**
     * The IdTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 32
     * @var string
     */
    public $IdTier;
    /**
     * Constructor method for BlocIdTiers
     * @uses BlocIdTiers::setCdEtabFinnTier()
     * @uses BlocIdTiers::setIdTier()
     * @param string $cdEtabFinnTier
     * @param string $idTier
     */
    public function __construct($cdEtabFinnTier = null, $idTier = null)
    {
        $this
            ->setCdEtabFinnTier($cdEtabFinnTier)
            ->setIdTier($idTier);
    }
    /**
     * Get CdEtabFinnTier value
     * @return string
     */
    public function getCdEtabFinnTier()
    {
        return $this->CdEtabFinnTier;
    }
    /**
     * Set CdEtabFinnTier value
     * @param string $cdEtabFinnTier
     * @return \StructType\BlocIdTiers
     */
    public function setCdEtabFinnTier($cdEtabFinnTier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cdEtabFinnTier) && strlen($cdEtabFinnTier) > 5) || (is_array($cdEtabFinnTier) && count($cdEtabFinnTier) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($cdEtabFinnTier) ? strlen($cdEtabFinnTier) : count($cdEtabFinnTier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cdEtabFinnTier) && !is_string($cdEtabFinnTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cdEtabFinnTier)), __LINE__);
        }
        $this->CdEtabFinnTier = $cdEtabFinnTier;
        return $this;
    }
    /**
     * Get IdTier value
     * @return string
     */
    public function getIdTier()
    {
        return $this->IdTier;
    }
    /**
     * Set IdTier value
     * @param string $idTier
     * @return \StructType\BlocIdTiers
     */
    public function setIdTier($idTier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idTier) && strlen($idTier) > 32) || (is_array($idTier) && count($idTier) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($idTier) ? strlen($idTier) : count($idTier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idTier) && !is_string($idTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTier)), __LINE__);
        }
        $this->IdTier = $idTier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocIdTiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
