<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Application StructType
 * Meta informations extracted from the WSDL
 * - documentation: type décrivant une application
 * @subpackage Structs
 */
class Application extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Nom de l'application
     * @var string
     */
    public $name;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: version de l'application
     * @var string
     */
    public $version;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: entité responsable de la production de l'application (garante de la disponibilité de l'application) | entité du groupe en charge de la production. Valeurs proposées: IBP, NXS, ITCE à ajouter au niveau référentiel groupe
     * @var string
     */
    public $organisation;
    /**
     * Constructor method for Application
     * @uses Application::setName()
     * @uses Application::setVersion()
     * @uses Application::setOrganisation()
     * @param string $name
     * @param string $version
     * @param string $organisation
     */
    public function __construct($name = null, $version = null, $organisation = null)
    {
        $this
            ->setName($name)
            ->setVersion($version)
            ->setOrganisation($organisation);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Application
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Application
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \StructType\Application
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Application
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
