<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recuperer ServiceType
 * @subpackage Services
 */
class Recuperer extends AbstractSoapClientBase
{
    /**
     * Sets the GroupContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\GroupContext $groupContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGroupContext(\StructType\GroupContext $groupContext, $nameSpace = 'http://www.bpce.fr/xsd/peg/PEG_v0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'groupContext', $groupContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RecupererListeDetailTiers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: groupContext
     * - SOAPHeaderNamespaces: http://www.bpce.fr/xsd/peg/PEG_v0
     * - SOAPHeaderTypes: \StructType\GroupContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QstnRecupListDetlTier $parameters
     * @return \StructType\RepnRecupListDetlTier|bool
     */
    public function RecupererListeDetailTiers(\StructType\QstnRecupListDetlTier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RecupererListeDetailTiers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecupererTiersLies
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: groupContext
     * - SOAPHeaderNamespaces: http://www.bpce.fr/xsd/peg/PEG_v0
     * - SOAPHeaderTypes: \StructType\GroupContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QstnRecupTierLies $parameters
     * @return \StructType\RepnRecupTierLies|bool
     */
    public function RecupererTiersLies(\StructType\QstnRecupTierLies $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RecupererTiersLies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RepnRecupListDetlTier|\StructType\RepnRecupTierLies
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
