<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechercher ServiceType
 * @subpackage Services
 */
class Rechercher extends AbstractSoapClientBase
{
    /**
     * Sets the GroupContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\GroupContext $groupContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGroupContext(\StructType\GroupContext $groupContext, $nameSpace = 'http://www.bpce.fr/xsd/peg/PEG_v0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'groupContext', $groupContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RechercherTiers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: groupContext
     * - SOAPHeaderNamespaces: http://www.bpce.fr/xsd/peg/PEG_v0
     * - SOAPHeaderTypes: \StructType\GroupContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QstnRechTier $parameters
     * @return \StructType\RepnRechTier|bool
     */
    public function RechercherTiers(\StructType\QstnRechTier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RechercherTiers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RepnRechTier
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
