<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Recuperer ServiceType
 */
$recuperer = new \ServiceType\Recuperer($options);
$recuperer->setSoapHeaderGroupContext($groupContext);
/**
 * Sample call for RecupererListeDetailTiers operation/method
 */
if ($recuperer->RecupererListeDetailTiers(new \StructType\QstnRecupListDetlTier()) !== false) {
    print_r($recuperer->getResult());
} else {
    print_r($recuperer->getLastError());
}
/**
 * Sample call for RecupererTiersLies operation/method
 */
if ($recuperer->RecupererTiersLies(new \StructType\QstnRecupTierLies()) !== false) {
    print_r($recuperer->getResult());
} else {
    print_r($recuperer->getLastError());
}
/**
 * Samples for Rechercher ServiceType
 */
$rechercher = new \ServiceType\Rechercher($options);
$rechercher->setSoapHeaderGroupContext($groupContext);
/**
 * Sample call for RechercherTiers operation/method
 */
if ($rechercher->RechercherTiers(new \StructType\QstnRechTier()) !== false) {
    print_r($rechercher->getResult());
} else {
    print_r($rechercher->getLastError());
}
