<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Données techniques définissant l'utilisateur pour le compte de qui est réalisée l'appel de WS (Issu de données extraites du jeton de Fédération d'Identité ayant servi au reroutage IHM) - Solution temporaire en attendant le
 * token SAML véhiculé via WS-Security
 * @subpackage Structs
 */
class UserContext extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - documentation: Données descriptives de l'utilisateur pour le compte de qui est réalisée l'appel de WS (Issu de données extraites du jeton de Fédération d'Identité ayant servi au reroutage IHM) - Solution temporaire en attendant le token SAML
     * véhiculé via WS-Security
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * Constructor method for UserContext
     * @uses UserContext::setUserId()
     * @param string $userId
     */
    public function __construct($userId = null)
    {
        $this
            ->setUserId($userId);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\UserContext
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
