<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Run StructType
 * Meta informations extracted from the WSDL
 * - documentation: type décrivant un environnement d'exécution
 * @subpackage Structs
 */
class Run extends AbstractStructBase
{
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - documentation: Type de canal utilisé par l'utilisateur de l'application. Le canal est il normalisé? Si oui, un contrôle peut être mis en place par le fournisseur pour vérifier que le canal du consumerContext est le même que celui du
     * GoalContext
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The env
     * Meta informations extracted from the WSDL
     * - documentation: Type d'environnement utilisé par l'utilisateur de l'application. L'environnement est il normalisé?
     * - minOccurs: 0
     * @var string
     */
    public $env;
    /**
     * The companyCode
     * Meta informations extracted from the WSDL
     * - documentation: Nom de la banque de l'utilisateur de l'application | Code Banque du référentiel groupe sur 5 caractères
     * @var string
     */
    public $companyCode;
    /**
     * Constructor method for Run
     * @uses Run::setChannel()
     * @uses Run::setEnv()
     * @uses Run::setCompanyCode()
     * @param string $channel
     * @param string $env
     * @param string $companyCode
     */
    public function __construct($channel = null, $env = null, $companyCode = null)
    {
        $this
            ->setChannel($channel)
            ->setEnv($env)
            ->setCompanyCode($companyCode);
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \StructType\Run
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get env value
     * @return string|null
     */
    public function getEnv()
    {
        return $this->env;
    }
    /**
     * Set env value
     * @param string $env
     * @return \StructType\Run
     */
    public function setEnv($env = null)
    {
        // validation for constraint: string
        if (!is_null($env) && !is_string($env)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($env)), __LINE__);
        }
        $this->env = $env;
        return $this;
    }
    /**
     * Get companyCode value
     * @return string|null
     */
    public function getCompanyCode()
    {
        return $this->companyCode;
    }
    /**
     * Set companyCode value
     * @param string $companyCode
     * @return \StructType\Run
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyCode)), __LINE__);
        }
        $this->companyCode = $companyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Run
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
