<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepnRechTier StructType
 * @subpackage Structs
 */
class RepnRechTier extends AbstractStructBase
{
    /**
     * The BlocRetr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BlocRetr
     */
    public $BlocRetr;
    /**
     * The ListTiers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BlocTiers[]
     */
    public $ListTiers;
    /**
     * Constructor method for RepnRechTier
     * @uses RepnRechTier::setBlocRetr()
     * @uses RepnRechTier::setListTiers()
     * @param \StructType\BlocRetr $blocRetr
     * @param \StructType\BlocTiers[] $listTiers
     */
    public function __construct(\StructType\BlocRetr $blocRetr = null, array $listTiers = array())
    {
        $this
            ->setBlocRetr($blocRetr)
            ->setListTiers($listTiers);
    }
    /**
     * Get BlocRetr value
     * @return \StructType\BlocRetr
     */
    public function getBlocRetr()
    {
        return $this->BlocRetr;
    }
    /**
     * Set BlocRetr value
     * @param \StructType\BlocRetr $blocRetr
     * @return \StructType\RepnRechTier
     */
    public function setBlocRetr(\StructType\BlocRetr $blocRetr = null)
    {
        $this->BlocRetr = $blocRetr;
        return $this;
    }
    /**
     * Get ListTiers value
     * @return \StructType\BlocTiers[]|null
     */
    public function getListTiers()
    {
        return $this->ListTiers;
    }
    /**
     * Set ListTiers value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocTiers[] $listTiers
     * @return \StructType\RepnRechTier
     */
    public function setListTiers(array $listTiers = array())
    {
        foreach ($listTiers as $repnRechTierListTiersItem) {
            // validation for constraint: itemType
            if (!$repnRechTierListTiersItem instanceof \StructType\BlocTiers) {
                throw new \InvalidArgumentException(sprintf('The ListTiers property can only contain items of \StructType\BlocTiers, "%s" given', is_object($repnRechTierListTiersItem) ? get_class($repnRechTierListTiersItem) : gettype($repnRechTierListTiersItem)), __LINE__);
            }
        }
        $this->ListTiers = $listTiers;
        return $this;
    }
    /**
     * Add item to ListTiers value
     * @throws \InvalidArgumentException
     * @param \StructType\BlocTiers $item
     * @return \StructType\RepnRechTier
     */
    public function addToListTiers(\StructType\BlocTiers $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlocTiers) {
            throw new \InvalidArgumentException(sprintf('The ListTiers property can only contain items of \StructType\BlocTiers, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListTiers[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RepnRechTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
