<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocRechTiers StructType
 * @subpackage Structs
 */
class BlocRechTiers extends AbstractStructBase
{
    /**
     * The CdEtabFinnTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 5
     * @var string
     */
    public $CdEtabFinnTier;
    /**
     * The CdTypeRechPers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CdTypeRechPers;
    /**
     * The BlocPersPhys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlocPersPhys
     */
    public $BlocPersPhys;
    /**
     * The BlocCpte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlocCpte
     */
    public $BlocCpte;
    /**
     * The BlocPersMorl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlocPersMorl
     */
    public $BlocPersMorl;
    /**
     * Constructor method for BlocRechTiers
     * @uses BlocRechTiers::setCdEtabFinnTier()
     * @uses BlocRechTiers::setCdTypeRechPers()
     * @uses BlocRechTiers::setBlocPersPhys()
     * @uses BlocRechTiers::setBlocCpte()
     * @uses BlocRechTiers::setBlocPersMorl()
     * @param string $cdEtabFinnTier
     * @param string $cdTypeRechPers
     * @param \StructType\BlocPersPhys $blocPersPhys
     * @param \StructType\BlocCpte $blocCpte
     * @param \StructType\BlocPersMorl $blocPersMorl
     */
    public function __construct($cdEtabFinnTier = null, $cdTypeRechPers = null, \StructType\BlocPersPhys $blocPersPhys = null, \StructType\BlocCpte $blocCpte = null, \StructType\BlocPersMorl $blocPersMorl = null)
    {
        $this
            ->setCdEtabFinnTier($cdEtabFinnTier)
            ->setCdTypeRechPers($cdTypeRechPers)
            ->setBlocPersPhys($blocPersPhys)
            ->setBlocCpte($blocCpte)
            ->setBlocPersMorl($blocPersMorl);
    }
    /**
     * Get CdEtabFinnTier value
     * @return string
     */
    public function getCdEtabFinnTier()
    {
        return $this->CdEtabFinnTier;
    }
    /**
     * Set CdEtabFinnTier value
     * @param string $cdEtabFinnTier
     * @return \StructType\BlocRechTiers
     */
    public function setCdEtabFinnTier($cdEtabFinnTier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cdEtabFinnTier) && strlen($cdEtabFinnTier) > 5) || (is_array($cdEtabFinnTier) && count($cdEtabFinnTier) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($cdEtabFinnTier) ? strlen($cdEtabFinnTier) : count($cdEtabFinnTier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cdEtabFinnTier) && !is_string($cdEtabFinnTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cdEtabFinnTier)), __LINE__);
        }
        $this->CdEtabFinnTier = $cdEtabFinnTier;
        return $this;
    }
    /**
     * Get CdTypeRechPers value
     * @return string
     */
    public function getCdTypeRechPers()
    {
        return $this->CdTypeRechPers;
    }
    /**
     * Set CdTypeRechPers value
     * @uses \EnumType\CdTypeRechPers::valueIsValid()
     * @uses \EnumType\CdTypeRechPers::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cdTypeRechPers
     * @return \StructType\BlocRechTiers
     */
    public function setCdTypeRechPers($cdTypeRechPers = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CdTypeRechPers::valueIsValid($cdTypeRechPers)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cdTypeRechPers, implode(', ', \EnumType\CdTypeRechPers::getValidValues())), __LINE__);
        }
        $this->CdTypeRechPers = $cdTypeRechPers;
        return $this;
    }
    /**
     * Get BlocPersPhys value
     * @return \StructType\BlocPersPhys|null
     */
    public function getBlocPersPhys()
    {
        return $this->BlocPersPhys;
    }
    /**
     * Set BlocPersPhys value
     * @param \StructType\BlocPersPhys $blocPersPhys
     * @return \StructType\BlocRechTiers
     */
    public function setBlocPersPhys(\StructType\BlocPersPhys $blocPersPhys = null)
    {
        $this->BlocPersPhys = $blocPersPhys;
        return $this;
    }
    /**
     * Get BlocCpte value
     * @return \StructType\BlocCpte|null
     */
    public function getBlocCpte()
    {
        return $this->BlocCpte;
    }
    /**
     * Set BlocCpte value
     * @param \StructType\BlocCpte $blocCpte
     * @return \StructType\BlocRechTiers
     */
    public function setBlocCpte(\StructType\BlocCpte $blocCpte = null)
    {
        $this->BlocCpte = $blocCpte;
        return $this;
    }
    /**
     * Get BlocPersMorl value
     * @return \StructType\BlocPersMorl|null
     */
    public function getBlocPersMorl()
    {
        return $this->BlocPersMorl;
    }
    /**
     * Set BlocPersMorl value
     * @param \StructType\BlocPersMorl $blocPersMorl
     * @return \StructType\BlocRechTiers
     */
    public function setBlocPersMorl(\StructType\BlocPersMorl $blocPersMorl = null)
    {
        $this->BlocPersMorl = $blocPersMorl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocRechTiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
