<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocMess StructType
 * @subpackage Structs
 */
class BlocMess extends AbstractStructBase
{
    /**
     * The IdMess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdMess;
    /**
     * The ListMess
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ListMess;
    /**
     * Constructor method for BlocMess
     * @uses BlocMess::setIdMess()
     * @uses BlocMess::setListMess()
     * @param string $idMess
     * @param string[] $listMess
     */
    public function __construct($idMess = null, array $listMess = array())
    {
        $this
            ->setIdMess($idMess)
            ->setListMess($listMess);
    }
    /**
     * Get IdMess value
     * @return string
     */
    public function getIdMess()
    {
        return $this->IdMess;
    }
    /**
     * Set IdMess value
     * @param string $idMess
     * @return \StructType\BlocMess
     */
    public function setIdMess($idMess = null)
    {
        // validation for constraint: string
        if (!is_null($idMess) && !is_string($idMess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idMess)), __LINE__);
        }
        $this->IdMess = $idMess;
        return $this;
    }
    /**
     * Get ListMess value
     * @return string[]|null
     */
    public function getListMess()
    {
        return $this->ListMess;
    }
    /**
     * Set ListMess value
     * @throws \InvalidArgumentException
     * @param string[] $listMess
     * @return \StructType\BlocMess
     */
    public function setListMess(array $listMess = array())
    {
        foreach ($listMess as $blocMessListMessItem) {
            // validation for constraint: itemType
            if (!is_string($blocMessListMessItem)) {
                throw new \InvalidArgumentException(sprintf('The ListMess property can only contain items of string, "%s" given', is_object($blocMessListMessItem) ? get_class($blocMessListMessItem) : gettype($blocMessListMessItem)), __LINE__);
            }
        }
        $this->ListMess = $listMess;
        return $this;
    }
    /**
     * Add item to ListMess value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BlocMess
     */
    public function addToListMess($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ListMess property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListMess[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocMess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
