<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlocCpte StructType
 * @subpackage Structs
 */
class BlocCpte extends AbstractStructBase
{
    /**
     * The CodeCritAccesCpte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeCritAccesCpte;
    /**
     * The NumrRibCpte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 21
     * @var string
     */
    public $NumrRibCpte;
    /**
     * The NumrCpteIban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 34
     * @var string
     */
    public $NumrCpteIban;
    /**
     * Constructor method for BlocCpte
     * @uses BlocCpte::setCodeCritAccesCpte()
     * @uses BlocCpte::setNumrRibCpte()
     * @uses BlocCpte::setNumrCpteIban()
     * @param string $codeCritAccesCpte
     * @param string $numrRibCpte
     * @param string $numrCpteIban
     */
    public function __construct($codeCritAccesCpte = null, $numrRibCpte = null, $numrCpteIban = null)
    {
        $this
            ->setCodeCritAccesCpte($codeCritAccesCpte)
            ->setNumrRibCpte($numrRibCpte)
            ->setNumrCpteIban($numrCpteIban);
    }
    /**
     * Get CodeCritAccesCpte value
     * @return string|null
     */
    public function getCodeCritAccesCpte()
    {
        return $this->CodeCritAccesCpte;
    }
    /**
     * Set CodeCritAccesCpte value
     * @uses \EnumType\CodeCritAccesCpte::valueIsValid()
     * @uses \EnumType\CodeCritAccesCpte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeCritAccesCpte
     * @return \StructType\BlocCpte
     */
    public function setCodeCritAccesCpte($codeCritAccesCpte = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodeCritAccesCpte::valueIsValid($codeCritAccesCpte)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codeCritAccesCpte, implode(', ', \EnumType\CodeCritAccesCpte::getValidValues())), __LINE__);
        }
        $this->CodeCritAccesCpte = $codeCritAccesCpte;
        return $this;
    }
    /**
     * Get NumrRibCpte value
     * @return string|null
     */
    public function getNumrRibCpte()
    {
        return $this->NumrRibCpte;
    }
    /**
     * Set NumrRibCpte value
     * @param string $numrRibCpte
     * @return \StructType\BlocCpte
     */
    public function setNumrRibCpte($numrRibCpte = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numrRibCpte) && strlen($numrRibCpte) > 21) || (is_array($numrRibCpte) && count($numrRibCpte) > 21)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 21 element(s) or a scalar of 21 character(s) at most, "%d" length given', is_scalar($numrRibCpte) ? strlen($numrRibCpte) : count($numrRibCpte)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numrRibCpte) && !is_string($numrRibCpte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numrRibCpte)), __LINE__);
        }
        $this->NumrRibCpte = $numrRibCpte;
        return $this;
    }
    /**
     * Get NumrCpteIban value
     * @return string|null
     */
    public function getNumrCpteIban()
    {
        return $this->NumrCpteIban;
    }
    /**
     * Set NumrCpteIban value
     * @param string $numrCpteIban
     * @return \StructType\BlocCpte
     */
    public function setNumrCpteIban($numrCpteIban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numrCpteIban) && strlen($numrCpteIban) > 34) || (is_array($numrCpteIban) && count($numrCpteIban) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($numrCpteIban) ? strlen($numrCpteIban) : count($numrCpteIban)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numrCpteIban) && !is_string($numrCpteIban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numrCpteIban)), __LINE__);
        }
        $this->NumrCpteIban = $numrCpteIban;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlocCpte
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
