<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UNIT1 StructType
 * @subpackage Structs
 */
class UNIT1 extends AbstractStructBase
{
    /**
     * The ACCOUNTCUSTOMERID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ACCOUNTCUSTOMERID;
    /**
     * The ADDRESS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 256
     * @var string
     */
    public $ADDRESS;
    /**
     * The APPLICATIONID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The APPLICATION_VERSION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The AUDITCREATEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDITMODIFIEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_CREATE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDIT_DELETED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The CAN_ACCEPTS_CARGO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_ACCEPTS_CARGO;
    /**
     * The CAN_COLLECTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_COLLECTION;
    /**
     * The CAN_COLLECTION_REDIRECTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_COLLECTION_REDIRECTION;
    /**
     * The CAN_DISTRIBUTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_DISTRIBUTION;
    /**
     * The CAN_INTERNAL_CARGO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_INTERNAL_CARGO;
    /**
     * The CAN_INVOICE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_INVOICE;
    /**
     * The CAN_REDIRECTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_REDIRECTION;
    /**
     * The CAN_WAYBILL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CAN_WAYBILL;
    /**
     * The CLOSED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CLOSED;
    /**
     * The CODE
     * Meta informations extracted from the WSDL
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The DISCOUNT_RATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DISCOUNT_RATE;
    /**
     * The EMAIL1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $EMAIL1;
    /**
     * The EMAIL2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $EMAIL2;
    /**
     * The FINISH_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FINISH_DATE;
    /**
     * The HINTCITYID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HINTCITYID;
    /**
     * The HINTTOWNID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HINTTOWNID;
    /**
     * The LOVORGANIZATIONID
     * @var float
     */
    public $LOVORGANIZATIONID;
    /**
     * The LOVUNITGROUPID
     * @var float
     */
    public $LOVUNITGROUPID;
    /**
     * The LOVUNITTYPEID
     * @var float
     */
    public $LOVUNITTYPEID;
    /**
     * The MANIFESTUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MANIFESTUNITID;
    /**
     * The MERSIS_NUMBER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 36
     * @var string
     */
    public $MERSIS_NUMBER;
    /**
     * The MOBILE_PHONE1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MOBILE_PHONE1;
    /**
     * The MOBILE_PHONE2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MOBILE_PHONE2;
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The OLD_UNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $OLD_UNITID;
    /**
     * The OPERATION_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $OPERATION_CODE;
    /**
     * The PARENTUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PARENTUNITID;
    /**
     * The PHONE1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $PHONE1;
    /**
     * The PHONE2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $PHONE2;
    /**
     * The RECEIVERHUBUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RECEIVERHUBUNITID;
    /**
     * The REPLACEUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $REPLACEUNITID;
    /**
     * The RINGHUBUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RINGHUBUNITID;
    /**
     * The ROUTETEMPLATEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ROUTETEMPLATEID;
    /**
     * The SENDERHUBUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SENDERHUBUNITID;
    /**
     * The SHORT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $SHORT_CODE;
    /**
     * The START_DATE
     * @var string
     */
    public $START_DATE;
    /**
     * The UNITID
     * @var float
     */
    public $UNITID;
    /**
     * Constructor method for UNIT1
     * @uses UNIT1::setACCOUNTCUSTOMERID()
     * @uses UNIT1::setADDRESS()
     * @uses UNIT1::setAPPLICATIONID()
     * @uses UNIT1::setAPPLICATION_VERSION()
     * @uses UNIT1::setAUDITCREATEDBY()
     * @uses UNIT1::setAUDITCREATEUNITID()
     * @uses UNIT1::setAUDITMODIFIEDBY()
     * @uses UNIT1::setAUDITMODIFYUNITID()
     * @uses UNIT1::setAUDIT_CREATE_DATE()
     * @uses UNIT1::setAUDIT_DELETED()
     * @uses UNIT1::setAUDIT_MODIFY_DATE()
     * @uses UNIT1::setCAN_ACCEPTS_CARGO()
     * @uses UNIT1::setCAN_COLLECTION()
     * @uses UNIT1::setCAN_COLLECTION_REDIRECTION()
     * @uses UNIT1::setCAN_DISTRIBUTION()
     * @uses UNIT1::setCAN_INTERNAL_CARGO()
     * @uses UNIT1::setCAN_INVOICE()
     * @uses UNIT1::setCAN_REDIRECTION()
     * @uses UNIT1::setCAN_WAYBILL()
     * @uses UNIT1::setCLOSED()
     * @uses UNIT1::setCODE()
     * @uses UNIT1::setDISCOUNT_RATE()
     * @uses UNIT1::setEMAIL1()
     * @uses UNIT1::setEMAIL2()
     * @uses UNIT1::setFINISH_DATE()
     * @uses UNIT1::setHINTCITYID()
     * @uses UNIT1::setHINTTOWNID()
     * @uses UNIT1::setLOVORGANIZATIONID()
     * @uses UNIT1::setLOVUNITGROUPID()
     * @uses UNIT1::setLOVUNITTYPEID()
     * @uses UNIT1::setMANIFESTUNITID()
     * @uses UNIT1::setMERSIS_NUMBER()
     * @uses UNIT1::setMOBILE_PHONE1()
     * @uses UNIT1::setMOBILE_PHONE2()
     * @uses UNIT1::setNAME()
     * @uses UNIT1::setOLD_UNITID()
     * @uses UNIT1::setOPERATION_CODE()
     * @uses UNIT1::setPARENTUNITID()
     * @uses UNIT1::setPHONE1()
     * @uses UNIT1::setPHONE2()
     * @uses UNIT1::setRECEIVERHUBUNITID()
     * @uses UNIT1::setREPLACEUNITID()
     * @uses UNIT1::setRINGHUBUNITID()
     * @uses UNIT1::setROUTETEMPLATEID()
     * @uses UNIT1::setSENDERHUBUNITID()
     * @uses UNIT1::setSHORT_CODE()
     * @uses UNIT1::setSTART_DATE()
     * @uses UNIT1::setUNITID()
     * @param string $aCCOUNTCUSTOMERID
     * @param string $aDDRESS
     * @param float $aPPLICATIONID
     * @param string $aPPLICATION_VERSION
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_CREATE_DATE
     * @param string $aUDIT_DELETED
     * @param string $aUDIT_MODIFY_DATE
     * @param string $cAN_ACCEPTS_CARGO
     * @param string $cAN_COLLECTION
     * @param string $cAN_COLLECTION_REDIRECTION
     * @param string $cAN_DISTRIBUTION
     * @param string $cAN_INTERNAL_CARGO
     * @param string $cAN_INVOICE
     * @param string $cAN_REDIRECTION
     * @param string $cAN_WAYBILL
     * @param string $cLOSED
     * @param string $cODE
     * @param float $dISCOUNT_RATE
     * @param string $eMAIL1
     * @param string $eMAIL2
     * @param string $fINISH_DATE
     * @param string $hINTCITYID
     * @param string $hINTTOWNID
     * @param float $lOVORGANIZATIONID
     * @param float $lOVUNITGROUPID
     * @param float $lOVUNITTYPEID
     * @param float $mANIFESTUNITID
     * @param string $mERSIS_NUMBER
     * @param string $mOBILE_PHONE1
     * @param string $mOBILE_PHONE2
     * @param string $nAME
     * @param string $oLD_UNITID
     * @param string $oPERATION_CODE
     * @param float $pARENTUNITID
     * @param string $pHONE1
     * @param string $pHONE2
     * @param float $rECEIVERHUBUNITID
     * @param float $rEPLACEUNITID
     * @param float $rINGHUBUNITID
     * @param string $rOUTETEMPLATEID
     * @param float $sENDERHUBUNITID
     * @param string $sHORT_CODE
     * @param string $sTART_DATE
     * @param float $uNITID
     */
    public function __construct($aCCOUNTCUSTOMERID = null, $aDDRESS = null, $aPPLICATIONID = null, $aPPLICATION_VERSION = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_CREATE_DATE = null, $aUDIT_DELETED = null, $aUDIT_MODIFY_DATE = null, $cAN_ACCEPTS_CARGO = null, $cAN_COLLECTION = null, $cAN_COLLECTION_REDIRECTION = null, $cAN_DISTRIBUTION = null, $cAN_INTERNAL_CARGO = null, $cAN_INVOICE = null, $cAN_REDIRECTION = null, $cAN_WAYBILL = null, $cLOSED = null, $cODE = null, $dISCOUNT_RATE = null, $eMAIL1 = null, $eMAIL2 = null, $fINISH_DATE = null, $hINTCITYID = null, $hINTTOWNID = null, $lOVORGANIZATIONID = null, $lOVUNITGROUPID = null, $lOVUNITTYPEID = null, $mANIFESTUNITID = null, $mERSIS_NUMBER = null, $mOBILE_PHONE1 = null, $mOBILE_PHONE2 = null, $nAME = null, $oLD_UNITID = null, $oPERATION_CODE = null, $pARENTUNITID = null, $pHONE1 = null, $pHONE2 = null, $rECEIVERHUBUNITID = null, $rEPLACEUNITID = null, $rINGHUBUNITID = null, $rOUTETEMPLATEID = null, $sENDERHUBUNITID = null, $sHORT_CODE = null, $sTART_DATE = null, $uNITID = null)
    {
        $this
            ->setACCOUNTCUSTOMERID($aCCOUNTCUSTOMERID)
            ->setADDRESS($aDDRESS)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setCAN_ACCEPTS_CARGO($cAN_ACCEPTS_CARGO)
            ->setCAN_COLLECTION($cAN_COLLECTION)
            ->setCAN_COLLECTION_REDIRECTION($cAN_COLLECTION_REDIRECTION)
            ->setCAN_DISTRIBUTION($cAN_DISTRIBUTION)
            ->setCAN_INTERNAL_CARGO($cAN_INTERNAL_CARGO)
            ->setCAN_INVOICE($cAN_INVOICE)
            ->setCAN_REDIRECTION($cAN_REDIRECTION)
            ->setCAN_WAYBILL($cAN_WAYBILL)
            ->setCLOSED($cLOSED)
            ->setCODE($cODE)
            ->setDISCOUNT_RATE($dISCOUNT_RATE)
            ->setEMAIL1($eMAIL1)
            ->setEMAIL2($eMAIL2)
            ->setFINISH_DATE($fINISH_DATE)
            ->setHINTCITYID($hINTCITYID)
            ->setHINTTOWNID($hINTTOWNID)
            ->setLOVORGANIZATIONID($lOVORGANIZATIONID)
            ->setLOVUNITGROUPID($lOVUNITGROUPID)
            ->setLOVUNITTYPEID($lOVUNITTYPEID)
            ->setMANIFESTUNITID($mANIFESTUNITID)
            ->setMERSIS_NUMBER($mERSIS_NUMBER)
            ->setMOBILE_PHONE1($mOBILE_PHONE1)
            ->setMOBILE_PHONE2($mOBILE_PHONE2)
            ->setNAME($nAME)
            ->setOLD_UNITID($oLD_UNITID)
            ->setOPERATION_CODE($oPERATION_CODE)
            ->setPARENTUNITID($pARENTUNITID)
            ->setPHONE1($pHONE1)
            ->setPHONE2($pHONE2)
            ->setRECEIVERHUBUNITID($rECEIVERHUBUNITID)
            ->setREPLACEUNITID($rEPLACEUNITID)
            ->setRINGHUBUNITID($rINGHUBUNITID)
            ->setROUTETEMPLATEID($rOUTETEMPLATEID)
            ->setSENDERHUBUNITID($sENDERHUBUNITID)
            ->setSHORT_CODE($sHORT_CODE)
            ->setSTART_DATE($sTART_DATE)
            ->setUNITID($uNITID);
    }
    /**
     * Get ACCOUNTCUSTOMERID value
     * @return string|null
     */
    public function getACCOUNTCUSTOMERID()
    {
        return $this->ACCOUNTCUSTOMERID;
    }
    /**
     * Set ACCOUNTCUSTOMERID value
     * @param string $aCCOUNTCUSTOMERID
     * @return \StructType\UNIT1
     */
    public function setACCOUNTCUSTOMERID($aCCOUNTCUSTOMERID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNTCUSTOMERID) && !is_string($aCCOUNTCUSTOMERID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCCOUNTCUSTOMERID)), __LINE__);
        }
        $this->ACCOUNTCUSTOMERID = $aCCOUNTCUSTOMERID;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \StructType\UNIT1
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aDDRESS) && strlen($aDDRESS) > 256) || (is_array($aDDRESS) && count($aDDRESS) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($aDDRESS) ? strlen($aDDRESS) : count($aDDRESS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \StructType\UNIT1
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \StructType\UNIT1
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aPPLICATION_VERSION) && strlen($aPPLICATION_VERSION) > 16) || (is_array($aPPLICATION_VERSION) && count($aPPLICATION_VERSION) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($aPPLICATION_VERSION) ? strlen($aPPLICATION_VERSION) : count($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \StructType\UNIT1
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \StructType\UNIT1
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \StructType\UNIT1
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \StructType\UNIT1
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \StructType\UNIT1
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \StructType\UNIT1
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aUDIT_DELETED) && strlen($aUDIT_DELETED) > 1) || (is_array($aUDIT_DELETED) && count($aUDIT_DELETED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($aUDIT_DELETED) ? strlen($aUDIT_DELETED) : count($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \StructType\UNIT1
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get CAN_ACCEPTS_CARGO value
     * @return string|null
     */
    public function getCAN_ACCEPTS_CARGO()
    {
        return $this->CAN_ACCEPTS_CARGO;
    }
    /**
     * Set CAN_ACCEPTS_CARGO value
     * @param string $cAN_ACCEPTS_CARGO
     * @return \StructType\UNIT1
     */
    public function setCAN_ACCEPTS_CARGO($cAN_ACCEPTS_CARGO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_ACCEPTS_CARGO) && strlen($cAN_ACCEPTS_CARGO) > 1) || (is_array($cAN_ACCEPTS_CARGO) && count($cAN_ACCEPTS_CARGO) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_ACCEPTS_CARGO) ? strlen($cAN_ACCEPTS_CARGO) : count($cAN_ACCEPTS_CARGO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_ACCEPTS_CARGO) && !is_string($cAN_ACCEPTS_CARGO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_ACCEPTS_CARGO)), __LINE__);
        }
        $this->CAN_ACCEPTS_CARGO = $cAN_ACCEPTS_CARGO;
        return $this;
    }
    /**
     * Get CAN_COLLECTION value
     * @return string|null
     */
    public function getCAN_COLLECTION()
    {
        return $this->CAN_COLLECTION;
    }
    /**
     * Set CAN_COLLECTION value
     * @param string $cAN_COLLECTION
     * @return \StructType\UNIT1
     */
    public function setCAN_COLLECTION($cAN_COLLECTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_COLLECTION) && strlen($cAN_COLLECTION) > 1) || (is_array($cAN_COLLECTION) && count($cAN_COLLECTION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_COLLECTION) ? strlen($cAN_COLLECTION) : count($cAN_COLLECTION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_COLLECTION) && !is_string($cAN_COLLECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_COLLECTION)), __LINE__);
        }
        $this->CAN_COLLECTION = $cAN_COLLECTION;
        return $this;
    }
    /**
     * Get CAN_COLLECTION_REDIRECTION value
     * @return string|null
     */
    public function getCAN_COLLECTION_REDIRECTION()
    {
        return $this->CAN_COLLECTION_REDIRECTION;
    }
    /**
     * Set CAN_COLLECTION_REDIRECTION value
     * @param string $cAN_COLLECTION_REDIRECTION
     * @return \StructType\UNIT1
     */
    public function setCAN_COLLECTION_REDIRECTION($cAN_COLLECTION_REDIRECTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_COLLECTION_REDIRECTION) && strlen($cAN_COLLECTION_REDIRECTION) > 1) || (is_array($cAN_COLLECTION_REDIRECTION) && count($cAN_COLLECTION_REDIRECTION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_COLLECTION_REDIRECTION) ? strlen($cAN_COLLECTION_REDIRECTION) : count($cAN_COLLECTION_REDIRECTION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_COLLECTION_REDIRECTION) && !is_string($cAN_COLLECTION_REDIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_COLLECTION_REDIRECTION)), __LINE__);
        }
        $this->CAN_COLLECTION_REDIRECTION = $cAN_COLLECTION_REDIRECTION;
        return $this;
    }
    /**
     * Get CAN_DISTRIBUTION value
     * @return string|null
     */
    public function getCAN_DISTRIBUTION()
    {
        return $this->CAN_DISTRIBUTION;
    }
    /**
     * Set CAN_DISTRIBUTION value
     * @param string $cAN_DISTRIBUTION
     * @return \StructType\UNIT1
     */
    public function setCAN_DISTRIBUTION($cAN_DISTRIBUTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_DISTRIBUTION) && strlen($cAN_DISTRIBUTION) > 1) || (is_array($cAN_DISTRIBUTION) && count($cAN_DISTRIBUTION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_DISTRIBUTION) ? strlen($cAN_DISTRIBUTION) : count($cAN_DISTRIBUTION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_DISTRIBUTION) && !is_string($cAN_DISTRIBUTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_DISTRIBUTION)), __LINE__);
        }
        $this->CAN_DISTRIBUTION = $cAN_DISTRIBUTION;
        return $this;
    }
    /**
     * Get CAN_INTERNAL_CARGO value
     * @return string|null
     */
    public function getCAN_INTERNAL_CARGO()
    {
        return $this->CAN_INTERNAL_CARGO;
    }
    /**
     * Set CAN_INTERNAL_CARGO value
     * @param string $cAN_INTERNAL_CARGO
     * @return \StructType\UNIT1
     */
    public function setCAN_INTERNAL_CARGO($cAN_INTERNAL_CARGO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_INTERNAL_CARGO) && strlen($cAN_INTERNAL_CARGO) > 1) || (is_array($cAN_INTERNAL_CARGO) && count($cAN_INTERNAL_CARGO) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_INTERNAL_CARGO) ? strlen($cAN_INTERNAL_CARGO) : count($cAN_INTERNAL_CARGO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_INTERNAL_CARGO) && !is_string($cAN_INTERNAL_CARGO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_INTERNAL_CARGO)), __LINE__);
        }
        $this->CAN_INTERNAL_CARGO = $cAN_INTERNAL_CARGO;
        return $this;
    }
    /**
     * Get CAN_INVOICE value
     * @return string|null
     */
    public function getCAN_INVOICE()
    {
        return $this->CAN_INVOICE;
    }
    /**
     * Set CAN_INVOICE value
     * @param string $cAN_INVOICE
     * @return \StructType\UNIT1
     */
    public function setCAN_INVOICE($cAN_INVOICE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_INVOICE) && strlen($cAN_INVOICE) > 1) || (is_array($cAN_INVOICE) && count($cAN_INVOICE) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_INVOICE) ? strlen($cAN_INVOICE) : count($cAN_INVOICE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_INVOICE) && !is_string($cAN_INVOICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_INVOICE)), __LINE__);
        }
        $this->CAN_INVOICE = $cAN_INVOICE;
        return $this;
    }
    /**
     * Get CAN_REDIRECTION value
     * @return string|null
     */
    public function getCAN_REDIRECTION()
    {
        return $this->CAN_REDIRECTION;
    }
    /**
     * Set CAN_REDIRECTION value
     * @param string $cAN_REDIRECTION
     * @return \StructType\UNIT1
     */
    public function setCAN_REDIRECTION($cAN_REDIRECTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_REDIRECTION) && strlen($cAN_REDIRECTION) > 1) || (is_array($cAN_REDIRECTION) && count($cAN_REDIRECTION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_REDIRECTION) ? strlen($cAN_REDIRECTION) : count($cAN_REDIRECTION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_REDIRECTION) && !is_string($cAN_REDIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_REDIRECTION)), __LINE__);
        }
        $this->CAN_REDIRECTION = $cAN_REDIRECTION;
        return $this;
    }
    /**
     * Get CAN_WAYBILL value
     * @return string|null
     */
    public function getCAN_WAYBILL()
    {
        return $this->CAN_WAYBILL;
    }
    /**
     * Set CAN_WAYBILL value
     * @param string $cAN_WAYBILL
     * @return \StructType\UNIT1
     */
    public function setCAN_WAYBILL($cAN_WAYBILL = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cAN_WAYBILL) && strlen($cAN_WAYBILL) > 1) || (is_array($cAN_WAYBILL) && count($cAN_WAYBILL) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cAN_WAYBILL) ? strlen($cAN_WAYBILL) : count($cAN_WAYBILL)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cAN_WAYBILL) && !is_string($cAN_WAYBILL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cAN_WAYBILL)), __LINE__);
        }
        $this->CAN_WAYBILL = $cAN_WAYBILL;
        return $this;
    }
    /**
     * Get CLOSED value
     * @return string|null
     */
    public function getCLOSED()
    {
        return $this->CLOSED;
    }
    /**
     * Set CLOSED value
     * @param string $cLOSED
     * @return \StructType\UNIT1
     */
    public function setCLOSED($cLOSED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cLOSED) && strlen($cLOSED) > 1) || (is_array($cLOSED) && count($cLOSED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cLOSED) ? strlen($cLOSED) : count($cLOSED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cLOSED) && !is_string($cLOSED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLOSED)), __LINE__);
        }
        $this->CLOSED = $cLOSED;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \StructType\UNIT1
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cODE) && strlen($cODE) > 8) || (is_array($cODE) && count($cODE) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($cODE) ? strlen($cODE) : count($cODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get DISCOUNT_RATE value
     * @return float|null
     */
    public function getDISCOUNT_RATE()
    {
        return $this->DISCOUNT_RATE;
    }
    /**
     * Set DISCOUNT_RATE value
     * @param float $dISCOUNT_RATE
     * @return \StructType\UNIT1
     */
    public function setDISCOUNT_RATE($dISCOUNT_RATE = null)
    {
        $this->DISCOUNT_RATE = $dISCOUNT_RATE;
        return $this;
    }
    /**
     * Get EMAIL1 value
     * @return string|null
     */
    public function getEMAIL1()
    {
        return $this->EMAIL1;
    }
    /**
     * Set EMAIL1 value
     * @param string $eMAIL1
     * @return \StructType\UNIT1
     */
    public function setEMAIL1($eMAIL1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eMAIL1) && strlen($eMAIL1) > 128) || (is_array($eMAIL1) && count($eMAIL1) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($eMAIL1) ? strlen($eMAIL1) : count($eMAIL1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eMAIL1) && !is_string($eMAIL1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL1)), __LINE__);
        }
        $this->EMAIL1 = $eMAIL1;
        return $this;
    }
    /**
     * Get EMAIL2 value
     * @return string|null
     */
    public function getEMAIL2()
    {
        return $this->EMAIL2;
    }
    /**
     * Set EMAIL2 value
     * @param string $eMAIL2
     * @return \StructType\UNIT1
     */
    public function setEMAIL2($eMAIL2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eMAIL2) && strlen($eMAIL2) > 128) || (is_array($eMAIL2) && count($eMAIL2) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($eMAIL2) ? strlen($eMAIL2) : count($eMAIL2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eMAIL2) && !is_string($eMAIL2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL2)), __LINE__);
        }
        $this->EMAIL2 = $eMAIL2;
        return $this;
    }
    /**
     * Get FINISH_DATE value
     * @return string|null
     */
    public function getFINISH_DATE()
    {
        return $this->FINISH_DATE;
    }
    /**
     * Set FINISH_DATE value
     * @param string $fINISH_DATE
     * @return \StructType\UNIT1
     */
    public function setFINISH_DATE($fINISH_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($fINISH_DATE) && !is_string($fINISH_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fINISH_DATE)), __LINE__);
        }
        $this->FINISH_DATE = $fINISH_DATE;
        return $this;
    }
    /**
     * Get HINTCITYID value
     * @return string|null
     */
    public function getHINTCITYID()
    {
        return $this->HINTCITYID;
    }
    /**
     * Set HINTCITYID value
     * @param string $hINTCITYID
     * @return \StructType\UNIT1
     */
    public function setHINTCITYID($hINTCITYID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTCITYID) && !is_string($hINTCITYID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hINTCITYID)), __LINE__);
        }
        $this->HINTCITYID = $hINTCITYID;
        return $this;
    }
    /**
     * Get HINTTOWNID value
     * @return string|null
     */
    public function getHINTTOWNID()
    {
        return $this->HINTTOWNID;
    }
    /**
     * Set HINTTOWNID value
     * @param string $hINTTOWNID
     * @return \StructType\UNIT1
     */
    public function setHINTTOWNID($hINTTOWNID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTTOWNID) && !is_string($hINTTOWNID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hINTTOWNID)), __LINE__);
        }
        $this->HINTTOWNID = $hINTTOWNID;
        return $this;
    }
    /**
     * Get LOVORGANIZATIONID value
     * @return float|null
     */
    public function getLOVORGANIZATIONID()
    {
        return $this->LOVORGANIZATIONID;
    }
    /**
     * Set LOVORGANIZATIONID value
     * @param float $lOVORGANIZATIONID
     * @return \StructType\UNIT1
     */
    public function setLOVORGANIZATIONID($lOVORGANIZATIONID = null)
    {
        $this->LOVORGANIZATIONID = $lOVORGANIZATIONID;
        return $this;
    }
    /**
     * Get LOVUNITGROUPID value
     * @return float|null
     */
    public function getLOVUNITGROUPID()
    {
        return $this->LOVUNITGROUPID;
    }
    /**
     * Set LOVUNITGROUPID value
     * @param float $lOVUNITGROUPID
     * @return \StructType\UNIT1
     */
    public function setLOVUNITGROUPID($lOVUNITGROUPID = null)
    {
        $this->LOVUNITGROUPID = $lOVUNITGROUPID;
        return $this;
    }
    /**
     * Get LOVUNITTYPEID value
     * @return float|null
     */
    public function getLOVUNITTYPEID()
    {
        return $this->LOVUNITTYPEID;
    }
    /**
     * Set LOVUNITTYPEID value
     * @param float $lOVUNITTYPEID
     * @return \StructType\UNIT1
     */
    public function setLOVUNITTYPEID($lOVUNITTYPEID = null)
    {
        $this->LOVUNITTYPEID = $lOVUNITTYPEID;
        return $this;
    }
    /**
     * Get MANIFESTUNITID value
     * @return float|null
     */
    public function getMANIFESTUNITID()
    {
        return $this->MANIFESTUNITID;
    }
    /**
     * Set MANIFESTUNITID value
     * @param float $mANIFESTUNITID
     * @return \StructType\UNIT1
     */
    public function setMANIFESTUNITID($mANIFESTUNITID = null)
    {
        $this->MANIFESTUNITID = $mANIFESTUNITID;
        return $this;
    }
    /**
     * Get MERSIS_NUMBER value
     * @return string|null
     */
    public function getMERSIS_NUMBER()
    {
        return $this->MERSIS_NUMBER;
    }
    /**
     * Set MERSIS_NUMBER value
     * @param string $mERSIS_NUMBER
     * @return \StructType\UNIT1
     */
    public function setMERSIS_NUMBER($mERSIS_NUMBER = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mERSIS_NUMBER) && strlen($mERSIS_NUMBER) > 36) || (is_array($mERSIS_NUMBER) && count($mERSIS_NUMBER) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($mERSIS_NUMBER) ? strlen($mERSIS_NUMBER) : count($mERSIS_NUMBER)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mERSIS_NUMBER) && !is_string($mERSIS_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mERSIS_NUMBER)), __LINE__);
        }
        $this->MERSIS_NUMBER = $mERSIS_NUMBER;
        return $this;
    }
    /**
     * Get MOBILE_PHONE1 value
     * @return string|null
     */
    public function getMOBILE_PHONE1()
    {
        return $this->MOBILE_PHONE1;
    }
    /**
     * Set MOBILE_PHONE1 value
     * @param string $mOBILE_PHONE1
     * @return \StructType\UNIT1
     */
    public function setMOBILE_PHONE1($mOBILE_PHONE1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mOBILE_PHONE1) && strlen($mOBILE_PHONE1) > 32) || (is_array($mOBILE_PHONE1) && count($mOBILE_PHONE1) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mOBILE_PHONE1) ? strlen($mOBILE_PHONE1) : count($mOBILE_PHONE1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mOBILE_PHONE1) && !is_string($mOBILE_PHONE1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOBILE_PHONE1)), __LINE__);
        }
        $this->MOBILE_PHONE1 = $mOBILE_PHONE1;
        return $this;
    }
    /**
     * Get MOBILE_PHONE2 value
     * @return string|null
     */
    public function getMOBILE_PHONE2()
    {
        return $this->MOBILE_PHONE2;
    }
    /**
     * Set MOBILE_PHONE2 value
     * @param string $mOBILE_PHONE2
     * @return \StructType\UNIT1
     */
    public function setMOBILE_PHONE2($mOBILE_PHONE2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mOBILE_PHONE2) && strlen($mOBILE_PHONE2) > 32) || (is_array($mOBILE_PHONE2) && count($mOBILE_PHONE2) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mOBILE_PHONE2) ? strlen($mOBILE_PHONE2) : count($mOBILE_PHONE2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mOBILE_PHONE2) && !is_string($mOBILE_PHONE2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOBILE_PHONE2)), __LINE__);
        }
        $this->MOBILE_PHONE2 = $mOBILE_PHONE2;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\UNIT1
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get OLD_UNITID value
     * @return string|null
     */
    public function getOLD_UNITID()
    {
        return $this->OLD_UNITID;
    }
    /**
     * Set OLD_UNITID value
     * @param string $oLD_UNITID
     * @return \StructType\UNIT1
     */
    public function setOLD_UNITID($oLD_UNITID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oLD_UNITID) && strlen($oLD_UNITID) > 8) || (is_array($oLD_UNITID) && count($oLD_UNITID) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($oLD_UNITID) ? strlen($oLD_UNITID) : count($oLD_UNITID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oLD_UNITID) && !is_string($oLD_UNITID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oLD_UNITID)), __LINE__);
        }
        $this->OLD_UNITID = $oLD_UNITID;
        return $this;
    }
    /**
     * Get OPERATION_CODE value
     * @return string|null
     */
    public function getOPERATION_CODE()
    {
        return $this->OPERATION_CODE;
    }
    /**
     * Set OPERATION_CODE value
     * @param string $oPERATION_CODE
     * @return \StructType\UNIT1
     */
    public function setOPERATION_CODE($oPERATION_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION_CODE) && strlen($oPERATION_CODE) > 3) || (is_array($oPERATION_CODE) && count($oPERATION_CODE) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($oPERATION_CODE) ? strlen($oPERATION_CODE) : count($oPERATION_CODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION_CODE) && !is_string($oPERATION_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION_CODE)), __LINE__);
        }
        $this->OPERATION_CODE = $oPERATION_CODE;
        return $this;
    }
    /**
     * Get PARENTUNITID value
     * @return float|null
     */
    public function getPARENTUNITID()
    {
        return $this->PARENTUNITID;
    }
    /**
     * Set PARENTUNITID value
     * @param float $pARENTUNITID
     * @return \StructType\UNIT1
     */
    public function setPARENTUNITID($pARENTUNITID = null)
    {
        $this->PARENTUNITID = $pARENTUNITID;
        return $this;
    }
    /**
     * Get PHONE1 value
     * @return string|null
     */
    public function getPHONE1()
    {
        return $this->PHONE1;
    }
    /**
     * Set PHONE1 value
     * @param string $pHONE1
     * @return \StructType\UNIT1
     */
    public function setPHONE1($pHONE1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pHONE1) && strlen($pHONE1) > 32) || (is_array($pHONE1) && count($pHONE1) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pHONE1) ? strlen($pHONE1) : count($pHONE1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pHONE1) && !is_string($pHONE1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pHONE1)), __LINE__);
        }
        $this->PHONE1 = $pHONE1;
        return $this;
    }
    /**
     * Get PHONE2 value
     * @return string|null
     */
    public function getPHONE2()
    {
        return $this->PHONE2;
    }
    /**
     * Set PHONE2 value
     * @param string $pHONE2
     * @return \StructType\UNIT1
     */
    public function setPHONE2($pHONE2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pHONE2) && strlen($pHONE2) > 32) || (is_array($pHONE2) && count($pHONE2) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pHONE2) ? strlen($pHONE2) : count($pHONE2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pHONE2) && !is_string($pHONE2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pHONE2)), __LINE__);
        }
        $this->PHONE2 = $pHONE2;
        return $this;
    }
    /**
     * Get RECEIVERHUBUNITID value
     * @return float|null
     */
    public function getRECEIVERHUBUNITID()
    {
        return $this->RECEIVERHUBUNITID;
    }
    /**
     * Set RECEIVERHUBUNITID value
     * @param float $rECEIVERHUBUNITID
     * @return \StructType\UNIT1
     */
    public function setRECEIVERHUBUNITID($rECEIVERHUBUNITID = null)
    {
        $this->RECEIVERHUBUNITID = $rECEIVERHUBUNITID;
        return $this;
    }
    /**
     * Get REPLACEUNITID value
     * @return float|null
     */
    public function getREPLACEUNITID()
    {
        return $this->REPLACEUNITID;
    }
    /**
     * Set REPLACEUNITID value
     * @param float $rEPLACEUNITID
     * @return \StructType\UNIT1
     */
    public function setREPLACEUNITID($rEPLACEUNITID = null)
    {
        $this->REPLACEUNITID = $rEPLACEUNITID;
        return $this;
    }
    /**
     * Get RINGHUBUNITID value
     * @return float|null
     */
    public function getRINGHUBUNITID()
    {
        return $this->RINGHUBUNITID;
    }
    /**
     * Set RINGHUBUNITID value
     * @param float $rINGHUBUNITID
     * @return \StructType\UNIT1
     */
    public function setRINGHUBUNITID($rINGHUBUNITID = null)
    {
        $this->RINGHUBUNITID = $rINGHUBUNITID;
        return $this;
    }
    /**
     * Get ROUTETEMPLATEID value
     * @return string|null
     */
    public function getROUTETEMPLATEID()
    {
        return $this->ROUTETEMPLATEID;
    }
    /**
     * Set ROUTETEMPLATEID value
     * @param string $rOUTETEMPLATEID
     * @return \StructType\UNIT1
     */
    public function setROUTETEMPLATEID($rOUTETEMPLATEID = null)
    {
        // validation for constraint: string
        if (!is_null($rOUTETEMPLATEID) && !is_string($rOUTETEMPLATEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rOUTETEMPLATEID)), __LINE__);
        }
        $this->ROUTETEMPLATEID = $rOUTETEMPLATEID;
        return $this;
    }
    /**
     * Get SENDERHUBUNITID value
     * @return float|null
     */
    public function getSENDERHUBUNITID()
    {
        return $this->SENDERHUBUNITID;
    }
    /**
     * Set SENDERHUBUNITID value
     * @param float $sENDERHUBUNITID
     * @return \StructType\UNIT1
     */
    public function setSENDERHUBUNITID($sENDERHUBUNITID = null)
    {
        $this->SENDERHUBUNITID = $sENDERHUBUNITID;
        return $this;
    }
    /**
     * Get SHORT_CODE value
     * @return string|null
     */
    public function getSHORT_CODE()
    {
        return $this->SHORT_CODE;
    }
    /**
     * Set SHORT_CODE value
     * @param string $sHORT_CODE
     * @return \StructType\UNIT1
     */
    public function setSHORT_CODE($sHORT_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sHORT_CODE) && strlen($sHORT_CODE) > 32) || (is_array($sHORT_CODE) && count($sHORT_CODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($sHORT_CODE) ? strlen($sHORT_CODE) : count($sHORT_CODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sHORT_CODE) && !is_string($sHORT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sHORT_CODE)), __LINE__);
        }
        $this->SHORT_CODE = $sHORT_CODE;
        return $this;
    }
    /**
     * Get START_DATE value
     * @return string|null
     */
    public function getSTART_DATE()
    {
        return $this->START_DATE;
    }
    /**
     * Set START_DATE value
     * @param string $sTART_DATE
     * @return \StructType\UNIT1
     */
    public function setSTART_DATE($sTART_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($sTART_DATE) && !is_string($sTART_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTART_DATE)), __LINE__);
        }
        $this->START_DATE = $sTART_DATE;
        return $this;
    }
    /**
     * Get UNITID value
     * @return float|null
     */
    public function getUNITID()
    {
        return $this->UNITID;
    }
    /**
     * Set UNITID value
     * @param float $uNITID
     * @return \StructType\UNIT1
     */
    public function setUNITID($uNITID = null)
    {
        $this->UNITID = $uNITID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UNIT1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
