<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSortedBag StructType
 * @subpackage Structs
 */
class SetSortedBag extends AbstractStructBase
{
    /**
     * The TargetUnitID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TargetUnitID;
    /**
     * The operatorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $operatorID;
    /**
     * The ReadPieceCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReadPieceCount;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The BagBarcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BagBarcode;
    /**
     * The pDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pDateTime;
    /**
     * The ProcessType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcessType;
    /**
     * The Barcodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcodes;
    /**
     * Constructor method for SetSortedBag
     * @uses SetSortedBag::setTargetUnitID()
     * @uses SetSortedBag::setOperatorID()
     * @uses SetSortedBag::setReadPieceCount()
     * @uses SetSortedBag::setUsername()
     * @uses SetSortedBag::setPassword()
     * @uses SetSortedBag::setBagBarcode()
     * @uses SetSortedBag::setPDateTime()
     * @uses SetSortedBag::setProcessType()
     * @uses SetSortedBag::setBarcodes()
     * @param int $targetUnitID
     * @param int $operatorID
     * @param int $readPieceCount
     * @param string $username
     * @param string $password
     * @param string $bagBarcode
     * @param string $pDateTime
     * @param string $processType
     * @param string $barcodes
     */
    public function __construct($targetUnitID = null, $operatorID = null, $readPieceCount = null, $username = null, $password = null, $bagBarcode = null, $pDateTime = null, $processType = null, $barcodes = null)
    {
        $this
            ->setTargetUnitID($targetUnitID)
            ->setOperatorID($operatorID)
            ->setReadPieceCount($readPieceCount)
            ->setUsername($username)
            ->setPassword($password)
            ->setBagBarcode($bagBarcode)
            ->setPDateTime($pDateTime)
            ->setProcessType($processType)
            ->setBarcodes($barcodes);
    }
    /**
     * Get TargetUnitID value
     * @return int
     */
    public function getTargetUnitID()
    {
        return $this->TargetUnitID;
    }
    /**
     * Set TargetUnitID value
     * @param int $targetUnitID
     * @return \StructType\SetSortedBag
     */
    public function setTargetUnitID($targetUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($targetUnitID) && !is_numeric($targetUnitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($targetUnitID)), __LINE__);
        }
        $this->TargetUnitID = $targetUnitID;
        return $this;
    }
    /**
     * Get operatorID value
     * @return int
     */
    public function getOperatorID()
    {
        return $this->operatorID;
    }
    /**
     * Set operatorID value
     * @param int $operatorID
     * @return \StructType\SetSortedBag
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: int
        if (!is_null($operatorID) && !is_numeric($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($operatorID)), __LINE__);
        }
        $this->operatorID = $operatorID;
        return $this;
    }
    /**
     * Get ReadPieceCount value
     * @return int
     */
    public function getReadPieceCount()
    {
        return $this->ReadPieceCount;
    }
    /**
     * Set ReadPieceCount value
     * @param int $readPieceCount
     * @return \StructType\SetSortedBag
     */
    public function setReadPieceCount($readPieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($readPieceCount) && !is_numeric($readPieceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($readPieceCount)), __LINE__);
        }
        $this->ReadPieceCount = $readPieceCount;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\SetSortedBag
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetSortedBag
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get BagBarcode value
     * @return string|null
     */
    public function getBagBarcode()
    {
        return $this->BagBarcode;
    }
    /**
     * Set BagBarcode value
     * @param string $bagBarcode
     * @return \StructType\SetSortedBag
     */
    public function setBagBarcode($bagBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($bagBarcode) && !is_string($bagBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bagBarcode)), __LINE__);
        }
        $this->BagBarcode = $bagBarcode;
        return $this;
    }
    /**
     * Get pDateTime value
     * @return string|null
     */
    public function getPDateTime()
    {
        return $this->pDateTime;
    }
    /**
     * Set pDateTime value
     * @param string $pDateTime
     * @return \StructType\SetSortedBag
     */
    public function setPDateTime($pDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pDateTime) && !is_string($pDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDateTime)), __LINE__);
        }
        $this->pDateTime = $pDateTime;
        return $this;
    }
    /**
     * Get ProcessType value
     * @return string|null
     */
    public function getProcessType()
    {
        return $this->ProcessType;
    }
    /**
     * Set ProcessType value
     * @param string $processType
     * @return \StructType\SetSortedBag
     */
    public function setProcessType($processType = null)
    {
        // validation for constraint: string
        if (!is_null($processType) && !is_string($processType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processType)), __LINE__);
        }
        $this->ProcessType = $processType;
        return $this;
    }
    /**
     * Get Barcodes value
     * @return string|null
     */
    public function getBarcodes()
    {
        return $this->Barcodes;
    }
    /**
     * Set Barcodes value
     * @param string $barcodes
     * @return \StructType\SetSortedBag
     */
    public function setBarcodes($barcodes = null)
    {
        // validation for constraint: string
        if (!is_null($barcodes) && !is_string($barcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodes)), __LINE__);
        }
        $this->Barcodes = $barcodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSortedBag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
