<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetDispatchXML StructType
 * @subpackage Structs
 */
class SetDispatchXML extends AbstractStructBase
{
    /**
     * The shippingOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShippingOrder
     */
    public $shippingOrders;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for SetDispatchXML
     * @uses SetDispatchXML::setShippingOrders()
     * @uses SetDispatchXML::setUserName()
     * @uses SetDispatchXML::setPassword()
     * @param \ArrayType\ArrayOfShippingOrder $shippingOrders
     * @param string $userName
     * @param string $password
     */
    public function __construct(\ArrayType\ArrayOfShippingOrder $shippingOrders = null, $userName = null, $password = null)
    {
        $this
            ->setShippingOrders($shippingOrders)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get shippingOrders value
     * @return \ArrayType\ArrayOfShippingOrder|null
     */
    public function getShippingOrders()
    {
        return $this->shippingOrders;
    }
    /**
     * Set shippingOrders value
     * @param \ArrayType\ArrayOfShippingOrder $shippingOrders
     * @return \StructType\SetDispatchXML
     */
    public function setShippingOrders(\ArrayType\ArrayOfShippingOrder $shippingOrders = null)
    {
        $this->shippingOrders = $shippingOrders;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\SetDispatchXML
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetDispatchXML
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetDispatchXML
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
