<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCargoLineInfo StructType
 * @subpackage Structs
 */
class SetCargoLineInfo extends AbstractStructBase
{
    /**
     * The unitcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $unitcode;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The tti_barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tti_barcode;
    /**
     * The barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The integration_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $integration_code;
    /**
     * The contents_description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contents_description;
    /**
     * The refcode1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refcode1;
    /**
     * The refcode2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refcode2;
    /**
     * Constructor method for SetCargoLineInfo
     * @uses SetCargoLineInfo::setUnitcode()
     * @uses SetCargoLineInfo::setUsername()
     * @uses SetCargoLineInfo::setPassword()
     * @uses SetCargoLineInfo::setTti_barcode()
     * @uses SetCargoLineInfo::setBarcode()
     * @uses SetCargoLineInfo::setIntegration_code()
     * @uses SetCargoLineInfo::setContents_description()
     * @uses SetCargoLineInfo::setRefcode1()
     * @uses SetCargoLineInfo::setRefcode2()
     * @param int $unitcode
     * @param string $username
     * @param string $password
     * @param string $tti_barcode
     * @param string $barcode
     * @param string $integration_code
     * @param string $contents_description
     * @param string $refcode1
     * @param string $refcode2
     */
    public function __construct($unitcode = null, $username = null, $password = null, $tti_barcode = null, $barcode = null, $integration_code = null, $contents_description = null, $refcode1 = null, $refcode2 = null)
    {
        $this
            ->setUnitcode($unitcode)
            ->setUsername($username)
            ->setPassword($password)
            ->setTti_barcode($tti_barcode)
            ->setBarcode($barcode)
            ->setIntegration_code($integration_code)
            ->setContents_description($contents_description)
            ->setRefcode1($refcode1)
            ->setRefcode2($refcode2);
    }
    /**
     * Get unitcode value
     * @return int
     */
    public function getUnitcode()
    {
        return $this->unitcode;
    }
    /**
     * Set unitcode value
     * @param int $unitcode
     * @return \StructType\SetCargoLineInfo
     */
    public function setUnitcode($unitcode = null)
    {
        // validation for constraint: int
        if (!is_null($unitcode) && !is_numeric($unitcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitcode)), __LINE__);
        }
        $this->unitcode = $unitcode;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\SetCargoLineInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetCargoLineInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get tti_barcode value
     * @return string|null
     */
    public function getTti_barcode()
    {
        return $this->tti_barcode;
    }
    /**
     * Set tti_barcode value
     * @param string $tti_barcode
     * @return \StructType\SetCargoLineInfo
     */
    public function setTti_barcode($tti_barcode = null)
    {
        // validation for constraint: string
        if (!is_null($tti_barcode) && !is_string($tti_barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tti_barcode)), __LINE__);
        }
        $this->tti_barcode = $tti_barcode;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \StructType\SetCargoLineInfo
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get integration_code value
     * @return string|null
     */
    public function getIntegration_code()
    {
        return $this->integration_code;
    }
    /**
     * Set integration_code value
     * @param string $integration_code
     * @return \StructType\SetCargoLineInfo
     */
    public function setIntegration_code($integration_code = null)
    {
        // validation for constraint: string
        if (!is_null($integration_code) && !is_string($integration_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integration_code)), __LINE__);
        }
        $this->integration_code = $integration_code;
        return $this;
    }
    /**
     * Get contents_description value
     * @return string|null
     */
    public function getContents_description()
    {
        return $this->contents_description;
    }
    /**
     * Set contents_description value
     * @param string $contents_description
     * @return \StructType\SetCargoLineInfo
     */
    public function setContents_description($contents_description = null)
    {
        // validation for constraint: string
        if (!is_null($contents_description) && !is_string($contents_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contents_description)), __LINE__);
        }
        $this->contents_description = $contents_description;
        return $this;
    }
    /**
     * Get refcode1 value
     * @return string|null
     */
    public function getRefcode1()
    {
        return $this->refcode1;
    }
    /**
     * Set refcode1 value
     * @param string $refcode1
     * @return \StructType\SetCargoLineInfo
     */
    public function setRefcode1($refcode1 = null)
    {
        // validation for constraint: string
        if (!is_null($refcode1) && !is_string($refcode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refcode1)), __LINE__);
        }
        $this->refcode1 = $refcode1;
        return $this;
    }
    /**
     * Get refcode2 value
     * @return string|null
     */
    public function getRefcode2()
    {
        return $this->refcode2;
    }
    /**
     * Set refcode2 value
     * @param string $refcode2
     * @return \StructType\SetCargoLineInfo
     */
    public function setRefcode2($refcode2 = null)
    {
        // validation for constraint: string
        if (!is_null($refcode2) && !is_string($refcode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refcode2)), __LINE__);
        }
        $this->refcode2 = $refcode2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCargoLineInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
