<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IrsData StructType
 * @subpackage Structs
 */
class IrsData extends AbstractStructBase
{
    /**
     * The ADET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The ALICI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ALICI;
    /**
     * The CIKIS_SUBE
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBE;
    /**
     * The DESI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The GONDERICI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $GONDERICI;
    /**
     * The IRSALIYE_SERI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $IRSALIYE_SERI;
    /**
     * The IRSALIYE_NUMARA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $IRSALIYE_NUMARA;
    /**
     * The IRSALIYE_TARIH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IRSALIYE_TARIH;
    /**
     * The MUSTERI_OZEL_KODU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MUSTERI_OZEL_KODU;
    /**
     * The ODEME_TIPI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $ODEME_TIPI;
    /**
     * The REFERANS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $REFERANS;
    /**
     * The TESLIM_ALAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_SAATI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The TESLIM_TARIHI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TUTAR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The VARIS_KODU
     * Meta informations extracted from the WSDL
     * - maxLength: 8
     * @var string
     */
    public $VARIS_KODU;
    /**
     * The VARIS_SUBE
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBE;
    /**
     * The TIP_KODU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $TIP_KODU;
    /**
     * The DURUM_KODU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $DURUM_KODU;
    /**
     * The DURUMU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 259
     * @var string
     */
    public $DURUMU;
    /**
     * The IADE_SEBEBI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $IADE_SEBEBI;
    /**
     * The KARGO_TAKIP_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KARGO_TAKIP_NO;
    /**
     * Constructor method for IrsData
     * @uses IrsData::setADET()
     * @uses IrsData::setALICI()
     * @uses IrsData::setCIKIS_SUBE()
     * @uses IrsData::setDESI()
     * @uses IrsData::setGONDERICI()
     * @uses IrsData::setIRSALIYE_SERI()
     * @uses IrsData::setIRSALIYE_NUMARA()
     * @uses IrsData::setIRSALIYE_TARIH()
     * @uses IrsData::setMUSTERI_OZEL_KODU()
     * @uses IrsData::setODEME_TIPI()
     * @uses IrsData::setREFERANS()
     * @uses IrsData::setTESLIM_ALAN()
     * @uses IrsData::setTESLIM_SAATI()
     * @uses IrsData::setTESLIM_TARIHI()
     * @uses IrsData::setTUTAR()
     * @uses IrsData::setVARIS_KODU()
     * @uses IrsData::setVARIS_SUBE()
     * @uses IrsData::setTIP_KODU()
     * @uses IrsData::setDURUM_KODU()
     * @uses IrsData::setDURUMU()
     * @uses IrsData::setIADE_SEBEBI()
     * @uses IrsData::setKARGO_TAKIP_NO()
     * @param float $aDET
     * @param string $aLICI
     * @param string $cIKIS_SUBE
     * @param float $dESI
     * @param string $gONDERICI
     * @param string $iRSALIYE_SERI
     * @param string $iRSALIYE_NUMARA
     * @param string $iRSALIYE_TARIH
     * @param string $mUSTERI_OZEL_KODU
     * @param string $oDEME_TIPI
     * @param string $rEFERANS
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_SAATI
     * @param string $tESLIM_TARIHI
     * @param float $tUTAR
     * @param string $vARIS_KODU
     * @param string $vARIS_SUBE
     * @param string $tIP_KODU
     * @param string $dURUM_KODU
     * @param string $dURUMU
     * @param string $iADE_SEBEBI
     * @param float $kARGO_TAKIP_NO
     */
    public function __construct($aDET = null, $aLICI = null, $cIKIS_SUBE = null, $dESI = null, $gONDERICI = null, $iRSALIYE_SERI = null, $iRSALIYE_NUMARA = null, $iRSALIYE_TARIH = null, $mUSTERI_OZEL_KODU = null, $oDEME_TIPI = null, $rEFERANS = null, $tESLIM_ALAN = null, $tESLIM_SAATI = null, $tESLIM_TARIHI = null, $tUTAR = null, $vARIS_KODU = null, $vARIS_SUBE = null, $tIP_KODU = null, $dURUM_KODU = null, $dURUMU = null, $iADE_SEBEBI = null, $kARGO_TAKIP_NO = null)
    {
        $this
            ->setADET($aDET)
            ->setALICI($aLICI)
            ->setCIKIS_SUBE($cIKIS_SUBE)
            ->setDESI($dESI)
            ->setGONDERICI($gONDERICI)
            ->setIRSALIYE_SERI($iRSALIYE_SERI)
            ->setIRSALIYE_NUMARA($iRSALIYE_NUMARA)
            ->setIRSALIYE_TARIH($iRSALIYE_TARIH)
            ->setMUSTERI_OZEL_KODU($mUSTERI_OZEL_KODU)
            ->setODEME_TIPI($oDEME_TIPI)
            ->setREFERANS($rEFERANS)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTUTAR($tUTAR)
            ->setVARIS_KODU($vARIS_KODU)
            ->setVARIS_SUBE($vARIS_SUBE)
            ->setTIP_KODU($tIP_KODU)
            ->setDURUM_KODU($dURUM_KODU)
            ->setDURUMU($dURUMU)
            ->setIADE_SEBEBI($iADE_SEBEBI)
            ->setKARGO_TAKIP_NO($kARGO_TAKIP_NO);
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \StructType\IrsData
     */
    public function setADET($aDET = null)
    {
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get ALICI value
     * @return string|null
     */
    public function getALICI()
    {
        return $this->ALICI;
    }
    /**
     * Set ALICI value
     * @param string $aLICI
     * @return \StructType\IrsData
     */
    public function setALICI($aLICI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aLICI) && strlen($aLICI) > 128) || (is_array($aLICI) && count($aLICI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aLICI) ? strlen($aLICI) : count($aLICI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aLICI) && !is_string($aLICI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLICI)), __LINE__);
        }
        $this->ALICI = $aLICI;
        return $this;
    }
    /**
     * Get CIKIS_SUBE value
     * @return string|null
     */
    public function getCIKIS_SUBE()
    {
        return $this->CIKIS_SUBE;
    }
    /**
     * Set CIKIS_SUBE value
     * @param string $cIKIS_SUBE
     * @return \StructType\IrsData
     */
    public function setCIKIS_SUBE($cIKIS_SUBE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_SUBE) && strlen($cIKIS_SUBE) > 32) || (is_array($cIKIS_SUBE) && count($cIKIS_SUBE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($cIKIS_SUBE) ? strlen($cIKIS_SUBE) : count($cIKIS_SUBE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_SUBE) && !is_string($cIKIS_SUBE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_SUBE)), __LINE__);
        }
        $this->CIKIS_SUBE = $cIKIS_SUBE;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \StructType\IrsData
     */
    public function setDESI($dESI = null)
    {
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get GONDERICI value
     * @return string|null
     */
    public function getGONDERICI()
    {
        return $this->GONDERICI;
    }
    /**
     * Set GONDERICI value
     * @param string $gONDERICI
     * @return \StructType\IrsData
     */
    public function setGONDERICI($gONDERICI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($gONDERICI) && strlen($gONDERICI) > 128) || (is_array($gONDERICI) && count($gONDERICI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($gONDERICI) ? strlen($gONDERICI) : count($gONDERICI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gONDERICI) && !is_string($gONDERICI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gONDERICI)), __LINE__);
        }
        $this->GONDERICI = $gONDERICI;
        return $this;
    }
    /**
     * Get IRSALIYE_SERI value
     * @return string|null
     */
    public function getIRSALIYE_SERI()
    {
        return $this->IRSALIYE_SERI;
    }
    /**
     * Set IRSALIYE_SERI value
     * @param string $iRSALIYE_SERI
     * @return \StructType\IrsData
     */
    public function setIRSALIYE_SERI($iRSALIYE_SERI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iRSALIYE_SERI) && strlen($iRSALIYE_SERI) > 2) || (is_array($iRSALIYE_SERI) && count($iRSALIYE_SERI) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($iRSALIYE_SERI) ? strlen($iRSALIYE_SERI) : count($iRSALIYE_SERI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iRSALIYE_SERI) && !is_string($iRSALIYE_SERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSALIYE_SERI)), __LINE__);
        }
        $this->IRSALIYE_SERI = $iRSALIYE_SERI;
        return $this;
    }
    /**
     * Get IRSALIYE_NUMARA value
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }
    /**
     * Set IRSALIYE_NUMARA value
     * @param string $iRSALIYE_NUMARA
     * @return \StructType\IrsData
     */
    public function setIRSALIYE_NUMARA($iRSALIYE_NUMARA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iRSALIYE_NUMARA) && strlen($iRSALIYE_NUMARA) > 8) || (is_array($iRSALIYE_NUMARA) && count($iRSALIYE_NUMARA) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iRSALIYE_NUMARA) ? strlen($iRSALIYE_NUMARA) : count($iRSALIYE_NUMARA)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iRSALIYE_NUMARA) && !is_string($iRSALIYE_NUMARA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSALIYE_NUMARA)), __LINE__);
        }
        $this->IRSALIYE_NUMARA = $iRSALIYE_NUMARA;
        return $this;
    }
    /**
     * Get IRSALIYE_TARIH value
     * @return string|null
     */
    public function getIRSALIYE_TARIH()
    {
        return $this->IRSALIYE_TARIH;
    }
    /**
     * Set IRSALIYE_TARIH value
     * @param string $iRSALIYE_TARIH
     * @return \StructType\IrsData
     */
    public function setIRSALIYE_TARIH($iRSALIYE_TARIH = null)
    {
        // validation for constraint: string
        if (!is_null($iRSALIYE_TARIH) && !is_string($iRSALIYE_TARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSALIYE_TARIH)), __LINE__);
        }
        $this->IRSALIYE_TARIH = $iRSALIYE_TARIH;
        return $this;
    }
    /**
     * Get MUSTERI_OZEL_KODU value
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }
    /**
     * Set MUSTERI_OZEL_KODU value
     * @param string $mUSTERI_OZEL_KODU
     * @return \StructType\IrsData
     */
    public function setMUSTERI_OZEL_KODU($mUSTERI_OZEL_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mUSTERI_OZEL_KODU) && strlen($mUSTERI_OZEL_KODU) > 32) || (is_array($mUSTERI_OZEL_KODU) && count($mUSTERI_OZEL_KODU) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mUSTERI_OZEL_KODU) ? strlen($mUSTERI_OZEL_KODU) : count($mUSTERI_OZEL_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mUSTERI_OZEL_KODU) && !is_string($mUSTERI_OZEL_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mUSTERI_OZEL_KODU)), __LINE__);
        }
        $this->MUSTERI_OZEL_KODU = $mUSTERI_OZEL_KODU;
        return $this;
    }
    /**
     * Get ODEME_TIPI value
     * @return string|null
     */
    public function getODEME_TIPI()
    {
        return $this->ODEME_TIPI;
    }
    /**
     * Set ODEME_TIPI value
     * @param string $oDEME_TIPI
     * @return \StructType\IrsData
     */
    public function setODEME_TIPI($oDEME_TIPI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oDEME_TIPI) && strlen($oDEME_TIPI) > 2) || (is_array($oDEME_TIPI) && count($oDEME_TIPI) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($oDEME_TIPI) ? strlen($oDEME_TIPI) : count($oDEME_TIPI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oDEME_TIPI) && !is_string($oDEME_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oDEME_TIPI)), __LINE__);
        }
        $this->ODEME_TIPI = $oDEME_TIPI;
        return $this;
    }
    /**
     * Get REFERANS value
     * @return string|null
     */
    public function getREFERANS()
    {
        return $this->REFERANS;
    }
    /**
     * Set REFERANS value
     * @param string $rEFERANS
     * @return \StructType\IrsData
     */
    public function setREFERANS($rEFERANS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rEFERANS) && strlen($rEFERANS) > 16) || (is_array($rEFERANS) && count($rEFERANS) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($rEFERANS) ? strlen($rEFERANS) : count($rEFERANS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rEFERANS) && !is_string($rEFERANS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEFERANS)), __LINE__);
        }
        $this->REFERANS = $rEFERANS;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \StructType\IrsData
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_ALAN) && strlen($tESLIM_ALAN) > 128) || (is_array($tESLIM_ALAN) && count($tESLIM_ALAN) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($tESLIM_ALAN) ? strlen($tESLIM_ALAN) : count($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \StructType\IrsData
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_SAATI) && strlen($tESLIM_SAATI) > 8) || (is_array($tESLIM_SAATI) && count($tESLIM_SAATI) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($tESLIM_SAATI) ? strlen($tESLIM_SAATI) : count($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \StructType\IrsData
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_TARIHI) && strlen($tESLIM_TARIHI) > 10) || (is_array($tESLIM_TARIHI) && count($tESLIM_TARIHI) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($tESLIM_TARIHI) ? strlen($tESLIM_TARIHI) : count($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \StructType\IrsData
     */
    public function setTUTAR($tUTAR = null)
    {
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get VARIS_KODU value
     * @return string|null
     */
    public function getVARIS_KODU()
    {
        return $this->VARIS_KODU;
    }
    /**
     * Set VARIS_KODU value
     * @param string $vARIS_KODU
     * @return \StructType\IrsData
     */
    public function setVARIS_KODU($vARIS_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_KODU) && strlen($vARIS_KODU) > 8) || (is_array($vARIS_KODU) && count($vARIS_KODU) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($vARIS_KODU) ? strlen($vARIS_KODU) : count($vARIS_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_KODU) && !is_string($vARIS_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_KODU)), __LINE__);
        }
        $this->VARIS_KODU = $vARIS_KODU;
        return $this;
    }
    /**
     * Get VARIS_SUBE value
     * @return string|null
     */
    public function getVARIS_SUBE()
    {
        return $this->VARIS_SUBE;
    }
    /**
     * Set VARIS_SUBE value
     * @param string $vARIS_SUBE
     * @return \StructType\IrsData
     */
    public function setVARIS_SUBE($vARIS_SUBE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_SUBE) && strlen($vARIS_SUBE) > 32) || (is_array($vARIS_SUBE) && count($vARIS_SUBE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($vARIS_SUBE) ? strlen($vARIS_SUBE) : count($vARIS_SUBE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_SUBE) && !is_string($vARIS_SUBE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_SUBE)), __LINE__);
        }
        $this->VARIS_SUBE = $vARIS_SUBE;
        return $this;
    }
    /**
     * Get TIP_KODU value
     * @return string|null
     */
    public function getTIP_KODU()
    {
        return $this->TIP_KODU;
    }
    /**
     * Set TIP_KODU value
     * @param string $tIP_KODU
     * @return \StructType\IrsData
     */
    public function setTIP_KODU($tIP_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tIP_KODU) && strlen($tIP_KODU) > 32) || (is_array($tIP_KODU) && count($tIP_KODU) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($tIP_KODU) ? strlen($tIP_KODU) : count($tIP_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tIP_KODU) && !is_string($tIP_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tIP_KODU)), __LINE__);
        }
        $this->TIP_KODU = $tIP_KODU;
        return $this;
    }
    /**
     * Get DURUM_KODU value
     * @return string|null
     */
    public function getDURUM_KODU()
    {
        return $this->DURUM_KODU;
    }
    /**
     * Set DURUM_KODU value
     * @param string $dURUM_KODU
     * @return \StructType\IrsData
     */
    public function setDURUM_KODU($dURUM_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dURUM_KODU) && strlen($dURUM_KODU) > 32) || (is_array($dURUM_KODU) && count($dURUM_KODU) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($dURUM_KODU) ? strlen($dURUM_KODU) : count($dURUM_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dURUM_KODU) && !is_string($dURUM_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dURUM_KODU)), __LINE__);
        }
        $this->DURUM_KODU = $dURUM_KODU;
        return $this;
    }
    /**
     * Get DURUMU value
     * @return string|null
     */
    public function getDURUMU()
    {
        return $this->DURUMU;
    }
    /**
     * Set DURUMU value
     * @param string $dURUMU
     * @return \StructType\IrsData
     */
    public function setDURUMU($dURUMU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dURUMU) && strlen($dURUMU) > 259) || (is_array($dURUMU) && count($dURUMU) > 259)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 259 element(s) or a scalar of 259 character(s) at most, "%d" length given', is_scalar($dURUMU) ? strlen($dURUMU) : count($dURUMU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dURUMU) && !is_string($dURUMU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dURUMU)), __LINE__);
        }
        $this->DURUMU = $dURUMU;
        return $this;
    }
    /**
     * Get IADE_SEBEBI value
     * @return string|null
     */
    public function getIADE_SEBEBI()
    {
        return $this->IADE_SEBEBI;
    }
    /**
     * Set IADE_SEBEBI value
     * @param string $iADE_SEBEBI
     * @return \StructType\IrsData
     */
    public function setIADE_SEBEBI($iADE_SEBEBI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iADE_SEBEBI) && strlen($iADE_SEBEBI) > 128) || (is_array($iADE_SEBEBI) && count($iADE_SEBEBI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($iADE_SEBEBI) ? strlen($iADE_SEBEBI) : count($iADE_SEBEBI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iADE_SEBEBI) && !is_string($iADE_SEBEBI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iADE_SEBEBI)), __LINE__);
        }
        $this->IADE_SEBEBI = $iADE_SEBEBI;
        return $this;
    }
    /**
     * Get KARGO_TAKIP_NO value
     * @return float|null
     */
    public function getKARGO_TAKIP_NO()
    {
        return $this->KARGO_TAKIP_NO;
    }
    /**
     * Set KARGO_TAKIP_NO value
     * @param float $kARGO_TAKIP_NO
     * @return \StructType\IrsData
     */
    public function setKARGO_TAKIP_NO($kARGO_TAKIP_NO = null)
    {
        $this->KARGO_TAKIP_NO = $kARGO_TAKIP_NO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IrsData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
