<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCargoSendList StructType
 * @subpackage Structs
 */
class GetCargoSendList extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The customerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerCode;
    /**
     * The tarih
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tarih;
    /**
     * Constructor method for GetCargoSendList
     * @uses GetCargoSendList::setUsername()
     * @uses GetCargoSendList::setPassword()
     * @uses GetCargoSendList::setCustomerCode()
     * @uses GetCargoSendList::setTarih()
     * @param string $username
     * @param string $password
     * @param string $customerCode
     * @param string $tarih
     */
    public function __construct($username = null, $password = null, $customerCode = null, $tarih = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setCustomerCode($customerCode)
            ->setTarih($tarih);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\GetCargoSendList
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetCargoSendList
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get customerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->customerCode;
    }
    /**
     * Set customerCode value
     * @param string $customerCode
     * @return \StructType\GetCargoSendList
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerCode)), __LINE__);
        }
        $this->customerCode = $customerCode;
        return $this;
    }
    /**
     * Get tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->tarih;
    }
    /**
     * Set tarih value
     * @param string $tarih
     * @return \StructType\GetCargoSendList
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tarih)), __LINE__);
        }
        $this->tarih = $tarih;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCargoSendList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
