<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ACCOUNT StructType
 * @subpackage Structs
 */
class ACCOUNT extends AbstractStructBase
{
    /**
     * The ACCOUNTID
     * @var string
     */
    public $ACCOUNTID;
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The LOVACCOUNTTYPEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LOVACCOUNTTYPEID;
    /**
     * The ACTIVE_VERSION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $ACTIVE_VERSION;
    /**
     * The AUDIT_CREATE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The LOVCUSTOMERTYPEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LOVCUSTOMERTYPEID;
    /**
     * The ERP_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $ERP_NO;
    /**
     * The TRANSFER_STATUS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $TRANSFER_STATUS;
    /**
     * The TRANSFER_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_DATE;
    /**
     * Constructor method for ACCOUNT
     * @uses ACCOUNT::setACCOUNTID()
     * @uses ACCOUNT::setNAME()
     * @uses ACCOUNT::setCODE()
     * @uses ACCOUNT::setLOVACCOUNTTYPEID()
     * @uses ACCOUNT::setACTIVE_VERSION()
     * @uses ACCOUNT::setAUDIT_CREATE_DATE()
     * @uses ACCOUNT::setAUDITCREATEDBY()
     * @uses ACCOUNT::setAUDITCREATEUNITID()
     * @uses ACCOUNT::setAUDIT_MODIFY_DATE()
     * @uses ACCOUNT::setAUDITMODIFIEDBY()
     * @uses ACCOUNT::setAUDITMODIFYUNITID()
     * @uses ACCOUNT::setAUDIT_DELETED()
     * @uses ACCOUNT::setAPPLICATION_VERSION()
     * @uses ACCOUNT::setAPPLICATIONID()
     * @uses ACCOUNT::setLOVCUSTOMERTYPEID()
     * @uses ACCOUNT::setERP_NO()
     * @uses ACCOUNT::setTRANSFER_STATUS()
     * @uses ACCOUNT::setTRANSFER_DATE()
     * @param string $aCCOUNTID
     * @param string $nAME
     * @param string $cODE
     * @param float $lOVACCOUNTTYPEID
     * @param string $aCTIVE_VERSION
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param float $lOVCUSTOMERTYPEID
     * @param string $eRP_NO
     * @param string $tRANSFER_STATUS
     * @param string $tRANSFER_DATE
     */
    public function __construct($aCCOUNTID = null, $nAME = null, $cODE = null, $lOVACCOUNTTYPEID = null, $aCTIVE_VERSION = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $lOVCUSTOMERTYPEID = null, $eRP_NO = null, $tRANSFER_STATUS = null, $tRANSFER_DATE = null)
    {
        $this
            ->setACCOUNTID($aCCOUNTID)
            ->setNAME($nAME)
            ->setCODE($cODE)
            ->setLOVACCOUNTTYPEID($lOVACCOUNTTYPEID)
            ->setACTIVE_VERSION($aCTIVE_VERSION)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setLOVCUSTOMERTYPEID($lOVCUSTOMERTYPEID)
            ->setERP_NO($eRP_NO)
            ->setTRANSFER_STATUS($tRANSFER_STATUS)
            ->setTRANSFER_DATE($tRANSFER_DATE);
    }
    /**
     * Get ACCOUNTID value
     * @return string|null
     */
    public function getACCOUNTID()
    {
        return $this->ACCOUNTID;
    }
    /**
     * Set ACCOUNTID value
     * @param string $aCCOUNTID
     * @return \StructType\ACCOUNT
     */
    public function setACCOUNTID($aCCOUNTID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNTID) && !is_string($aCCOUNTID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCCOUNTID)), __LINE__);
        }
        $this->ACCOUNTID = $aCCOUNTID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\ACCOUNT
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \StructType\ACCOUNT
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cODE) && strlen($cODE) > 8) || (is_array($cODE) && count($cODE) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($cODE) ? strlen($cODE) : count($cODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get LOVACCOUNTTYPEID value
     * @return float|null
     */
    public function getLOVACCOUNTTYPEID()
    {
        return $this->LOVACCOUNTTYPEID;
    }
    /**
     * Set LOVACCOUNTTYPEID value
     * @param float $lOVACCOUNTTYPEID
     * @return \StructType\ACCOUNT
     */
    public function setLOVACCOUNTTYPEID($lOVACCOUNTTYPEID = null)
    {
        $this->LOVACCOUNTTYPEID = $lOVACCOUNTTYPEID;
        return $this;
    }
    /**
     * Get ACTIVE_VERSION value
     * @return string|null
     */
    public function getACTIVE_VERSION()
    {
        return $this->ACTIVE_VERSION;
    }
    /**
     * Set ACTIVE_VERSION value
     * @param string $aCTIVE_VERSION
     * @return \StructType\ACCOUNT
     */
    public function setACTIVE_VERSION($aCTIVE_VERSION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aCTIVE_VERSION) && strlen($aCTIVE_VERSION) > 1) || (is_array($aCTIVE_VERSION) && count($aCTIVE_VERSION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($aCTIVE_VERSION) ? strlen($aCTIVE_VERSION) : count($aCTIVE_VERSION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aCTIVE_VERSION) && !is_string($aCTIVE_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCTIVE_VERSION)), __LINE__);
        }
        $this->ACTIVE_VERSION = $aCTIVE_VERSION;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \StructType\ACCOUNT
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \StructType\ACCOUNT
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \StructType\ACCOUNT
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \StructType\ACCOUNT
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \StructType\ACCOUNT
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \StructType\ACCOUNT
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \StructType\ACCOUNT
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aUDIT_DELETED) && strlen($aUDIT_DELETED) > 1) || (is_array($aUDIT_DELETED) && count($aUDIT_DELETED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($aUDIT_DELETED) ? strlen($aUDIT_DELETED) : count($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \StructType\ACCOUNT
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aPPLICATION_VERSION) && strlen($aPPLICATION_VERSION) > 16) || (is_array($aPPLICATION_VERSION) && count($aPPLICATION_VERSION) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($aPPLICATION_VERSION) ? strlen($aPPLICATION_VERSION) : count($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \StructType\ACCOUNT
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get LOVCUSTOMERTYPEID value
     * @return float|null
     */
    public function getLOVCUSTOMERTYPEID()
    {
        return $this->LOVCUSTOMERTYPEID;
    }
    /**
     * Set LOVCUSTOMERTYPEID value
     * @param float $lOVCUSTOMERTYPEID
     * @return \StructType\ACCOUNT
     */
    public function setLOVCUSTOMERTYPEID($lOVCUSTOMERTYPEID = null)
    {
        $this->LOVCUSTOMERTYPEID = $lOVCUSTOMERTYPEID;
        return $this;
    }
    /**
     * Get ERP_NO value
     * @return string|null
     */
    public function getERP_NO()
    {
        return $this->ERP_NO;
    }
    /**
     * Set ERP_NO value
     * @param string $eRP_NO
     * @return \StructType\ACCOUNT
     */
    public function setERP_NO($eRP_NO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eRP_NO) && strlen($eRP_NO) > 32) || (is_array($eRP_NO) && count($eRP_NO) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($eRP_NO) ? strlen($eRP_NO) : count($eRP_NO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eRP_NO) && !is_string($eRP_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eRP_NO)), __LINE__);
        }
        $this->ERP_NO = $eRP_NO;
        return $this;
    }
    /**
     * Get TRANSFER_STATUS value
     * @return string|null
     */
    public function getTRANSFER_STATUS()
    {
        return $this->TRANSFER_STATUS;
    }
    /**
     * Set TRANSFER_STATUS value
     * @param string $tRANSFER_STATUS
     * @return \StructType\ACCOUNT
     */
    public function setTRANSFER_STATUS($tRANSFER_STATUS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tRANSFER_STATUS) && strlen($tRANSFER_STATUS) > 1) || (is_array($tRANSFER_STATUS) && count($tRANSFER_STATUS) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($tRANSFER_STATUS) ? strlen($tRANSFER_STATUS) : count($tRANSFER_STATUS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tRANSFER_STATUS) && !is_string($tRANSFER_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tRANSFER_STATUS)), __LINE__);
        }
        $this->TRANSFER_STATUS = $tRANSFER_STATUS;
        return $this;
    }
    /**
     * Get TRANSFER_DATE value
     * @return string|null
     */
    public function getTRANSFER_DATE()
    {
        return $this->TRANSFER_DATE;
    }
    /**
     * Set TRANSFER_DATE value
     * @param string $tRANSFER_DATE
     * @return \StructType\ACCOUNT
     */
    public function setTRANSFER_DATE($tRANSFER_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_DATE) && !is_string($tRANSFER_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tRANSFER_DATE)), __LINE__);
        }
        $this->TRANSFER_DATE = $tRANSFER_DATE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ACCOUNT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
