<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDispatchResultInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfDispatchResultInfo extends AbstractStructArrayBase
{
    /**
     * The DispatchResultInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DispatchResultInfo[]
     */
    public $DispatchResultInfo;
    /**
     * Constructor method for ArrayOfDispatchResultInfo
     * @uses ArrayOfDispatchResultInfo::setDispatchResultInfo()
     * @param \StructType\DispatchResultInfo[] $dispatchResultInfo
     */
    public function __construct(array $dispatchResultInfo = array())
    {
        $this
            ->setDispatchResultInfo($dispatchResultInfo);
    }
    /**
     * Get DispatchResultInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DispatchResultInfo[]|null
     */
    public function getDispatchResultInfo()
    {
        return isset($this->DispatchResultInfo) ? $this->DispatchResultInfo : null;
    }
    /**
     * Set DispatchResultInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DispatchResultInfo[] $dispatchResultInfo
     * @return \ArrayType\ArrayOfDispatchResultInfo
     */
    public function setDispatchResultInfo(array $dispatchResultInfo = array())
    {
        foreach ($dispatchResultInfo as $arrayOfDispatchResultInfoDispatchResultInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDispatchResultInfoDispatchResultInfoItem instanceof \StructType\DispatchResultInfo) {
                throw new \InvalidArgumentException(sprintf('The DispatchResultInfo property can only contain items of \StructType\DispatchResultInfo, "%s" given', is_object($arrayOfDispatchResultInfoDispatchResultInfoItem) ? get_class($arrayOfDispatchResultInfoDispatchResultInfoItem) : gettype($arrayOfDispatchResultInfoDispatchResultInfoItem)), __LINE__);
            }
        }
        if (is_null($dispatchResultInfo) || (is_array($dispatchResultInfo) && empty($dispatchResultInfo))) {
            unset($this->DispatchResultInfo);
        } else {
            $this->DispatchResultInfo = $dispatchResultInfo;
        }
        return $this;
    }
    /**
     * Add item to DispatchResultInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DispatchResultInfo $item
     * @return \ArrayType\ArrayOfDispatchResultInfo
     */
    public function addToDispatchResultInfo(\StructType\DispatchResultInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DispatchResultInfo) {
            throw new \InvalidArgumentException(sprintf('The DispatchResultInfo property can only contain items of \StructType\DispatchResultInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DispatchResultInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DispatchResultInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DispatchResultInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DispatchResultInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DispatchResultInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DispatchResultInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DispatchResultInfo
     */
    public function getAttributeName()
    {
        return 'DispatchResultInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDispatchResultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
