<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressDto ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddressDto extends AbstractStructArrayBase
{
    /**
     * The AddressDto
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressDto[]
     */
    public $AddressDto;
    /**
     * Constructor method for ArrayOfAddressDto
     * @uses ArrayOfAddressDto::setAddressDto()
     * @param \StructType\AddressDto[] $addressDto
     */
    public function __construct(array $addressDto = array())
    {
        $this
            ->setAddressDto($addressDto);
    }
    /**
     * Get AddressDto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressDto[]|null
     */
    public function getAddressDto()
    {
        return isset($this->AddressDto) ? $this->AddressDto : null;
    }
    /**
     * Set AddressDto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddressDto[] $addressDto
     * @return \ArrayType\ArrayOfAddressDto
     */
    public function setAddressDto(array $addressDto = array())
    {
        foreach ($addressDto as $arrayOfAddressDtoAddressDtoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressDtoAddressDtoItem instanceof \StructType\AddressDto) {
                throw new \InvalidArgumentException(sprintf('The AddressDto property can only contain items of \StructType\AddressDto, "%s" given', is_object($arrayOfAddressDtoAddressDtoItem) ? get_class($arrayOfAddressDtoAddressDtoItem) : gettype($arrayOfAddressDtoAddressDtoItem)), __LINE__);
            }
        }
        if (is_null($addressDto) || (is_array($addressDto) && empty($addressDto))) {
            unset($this->AddressDto);
        } else {
            $this->AddressDto = $addressDto;
        }
        return $this;
    }
    /**
     * Add item to AddressDto value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressDto $item
     * @return \ArrayType\ArrayOfAddressDto
     */
    public function addToAddressDto(\StructType\AddressDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressDto) {
            throw new \InvalidArgumentException(sprintf('The AddressDto property can only contain items of \StructType\AddressDto, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressDto[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AddressDto|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AddressDto|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AddressDto|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AddressDto|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AddressDto|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressDto
     */
    public function getAttributeName()
    {
        return 'AddressDto';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAddressDto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
