<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA4 StructType
 * @subpackage Structs
 */
class WEBCARGODATA4 extends AbstractStructBase
{
    /**
     * The BOLGE_ADI
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $BOLGE_ADI;
    /**
     * The ADDRESS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 256
     * @var string
     */
    public $ADDRESS;
    /**
     * The ILCE
     * Meta informations extracted from the WSDL
     * - maxLength: 64
     * @var string
     */
    public $ILCE;
    /**
     * The TELEFON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $TELEFON;
    /**
     * The EMAIL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $EMAIL;
    /**
     * Constructor method for WEBCARGODATA4
     * @uses WEBCARGODATA4::setBOLGE_ADI()
     * @uses WEBCARGODATA4::setADDRESS()
     * @uses WEBCARGODATA4::setILCE()
     * @uses WEBCARGODATA4::setTELEFON()
     * @uses WEBCARGODATA4::setEMAIL()
     * @param string $bOLGE_ADI
     * @param string $aDDRESS
     * @param string $iLCE
     * @param string $tELEFON
     * @param string $eMAIL
     */
    public function __construct($bOLGE_ADI = null, $aDDRESS = null, $iLCE = null, $tELEFON = null, $eMAIL = null)
    {
        $this
            ->setBOLGE_ADI($bOLGE_ADI)
            ->setADDRESS($aDDRESS)
            ->setILCE($iLCE)
            ->setTELEFON($tELEFON)
            ->setEMAIL($eMAIL);
    }
    /**
     * Get BOLGE_ADI value
     * @return string|null
     */
    public function getBOLGE_ADI()
    {
        return $this->BOLGE_ADI;
    }
    /**
     * Set BOLGE_ADI value
     * @param string $bOLGE_ADI
     * @return \StructType\WEBCARGODATA4
     */
    public function setBOLGE_ADI($bOLGE_ADI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bOLGE_ADI) && strlen($bOLGE_ADI) > 32) || (is_array($bOLGE_ADI) && count($bOLGE_ADI) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($bOLGE_ADI) ? strlen($bOLGE_ADI) : count($bOLGE_ADI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bOLGE_ADI) && !is_string($bOLGE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bOLGE_ADI)), __LINE__);
        }
        $this->BOLGE_ADI = $bOLGE_ADI;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \StructType\WEBCARGODATA4
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aDDRESS) && strlen($aDDRESS) > 256) || (is_array($aDDRESS) && count($aDDRESS) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($aDDRESS) ? strlen($aDDRESS) : count($aDDRESS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get ILCE value
     * @return string|null
     */
    public function getILCE()
    {
        return $this->ILCE;
    }
    /**
     * Set ILCE value
     * @param string $iLCE
     * @return \StructType\WEBCARGODATA4
     */
    public function setILCE($iLCE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iLCE) && strlen($iLCE) > 64) || (is_array($iLCE) && count($iLCE) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($iLCE) ? strlen($iLCE) : count($iLCE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iLCE) && !is_string($iLCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iLCE)), __LINE__);
        }
        $this->ILCE = $iLCE;
        return $this;
    }
    /**
     * Get TELEFON value
     * @return string|null
     */
    public function getTELEFON()
    {
        return $this->TELEFON;
    }
    /**
     * Set TELEFON value
     * @param string $tELEFON
     * @return \StructType\WEBCARGODATA4
     */
    public function setTELEFON($tELEFON = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tELEFON) && strlen($tELEFON) > 32) || (is_array($tELEFON) && count($tELEFON) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($tELEFON) ? strlen($tELEFON) : count($tELEFON)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tELEFON) && !is_string($tELEFON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tELEFON)), __LINE__);
        }
        $this->TELEFON = $tELEFON;
        return $this;
    }
    /**
     * Get EMAIL value
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }
    /**
     * Set EMAIL value
     * @param string $eMAIL
     * @return \StructType\WEBCARGODATA4
     */
    public function setEMAIL($eMAIL = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eMAIL) && strlen($eMAIL) > 128) || (is_array($eMAIL) && count($eMAIL) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($eMAIL) ? strlen($eMAIL) : count($eMAIL)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eMAIL) && !is_string($eMAIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL)), __LINE__);
        }
        $this->EMAIL = $eMAIL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WEBCARGODATA4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
