<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HINTTOWN StructType
 * @subpackage Structs
 */
class HINTTOWN extends AbstractStructBase
{
    /**
     * The ILCE_ADI
     * Meta informations extracted from the WSDL
     * - maxLength: 64
     * @var string
     */
    public $ILCE_ADI;
    /**
     * The ILCE_KODU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $ILCE_KODU;
    /**
     * The HINTTOWNID
     * @var string
     */
    public $HINTTOWNID;
    /**
     * Constructor method for HINTTOWN
     * @uses HINTTOWN::setILCE_ADI()
     * @uses HINTTOWN::setILCE_KODU()
     * @uses HINTTOWN::setHINTTOWNID()
     * @param string $iLCE_ADI
     * @param string $iLCE_KODU
     * @param string $hINTTOWNID
     */
    public function __construct($iLCE_ADI = null, $iLCE_KODU = null, $hINTTOWNID = null)
    {
        $this
            ->setILCE_ADI($iLCE_ADI)
            ->setILCE_KODU($iLCE_KODU)
            ->setHINTTOWNID($hINTTOWNID);
    }
    /**
     * Get ILCE_ADI value
     * @return string|null
     */
    public function getILCE_ADI()
    {
        return $this->ILCE_ADI;
    }
    /**
     * Set ILCE_ADI value
     * @param string $iLCE_ADI
     * @return \StructType\HINTTOWN
     */
    public function setILCE_ADI($iLCE_ADI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iLCE_ADI) && strlen($iLCE_ADI) > 64) || (is_array($iLCE_ADI) && count($iLCE_ADI) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($iLCE_ADI) ? strlen($iLCE_ADI) : count($iLCE_ADI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iLCE_ADI) && !is_string($iLCE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iLCE_ADI)), __LINE__);
        }
        $this->ILCE_ADI = $iLCE_ADI;
        return $this;
    }
    /**
     * Get ILCE_KODU value
     * @return string|null
     */
    public function getILCE_KODU()
    {
        return $this->ILCE_KODU;
    }
    /**
     * Set ILCE_KODU value
     * @param string $iLCE_KODU
     * @return \StructType\HINTTOWN
     */
    public function setILCE_KODU($iLCE_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iLCE_KODU) && strlen($iLCE_KODU) > 16) || (is_array($iLCE_KODU) && count($iLCE_KODU) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($iLCE_KODU) ? strlen($iLCE_KODU) : count($iLCE_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iLCE_KODU) && !is_string($iLCE_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iLCE_KODU)), __LINE__);
        }
        $this->ILCE_KODU = $iLCE_KODU;
        return $this;
    }
    /**
     * Get HINTTOWNID value
     * @return string|null
     */
    public function getHINTTOWNID()
    {
        return $this->HINTTOWNID;
    }
    /**
     * Set HINTTOWNID value
     * @param string $hINTTOWNID
     * @return \StructType\HINTTOWN
     */
    public function setHINTTOWNID($hINTTOWNID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTTOWNID) && !is_string($hINTTOWNID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hINTTOWNID)), __LINE__);
        }
        $this->HINTTOWNID = $hINTTOWNID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HINTTOWN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
