<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBarcode StructType
 * @subpackage Structs
 */
class GetBarcode extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The integrationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $integrationCode;
    /**
     * Constructor method for GetBarcode
     * @uses GetBarcode::setUsername()
     * @uses GetBarcode::setPassword()
     * @uses GetBarcode::setIntegrationCode()
     * @param string $username
     * @param string $password
     * @param string $integrationCode
     */
    public function __construct($username = null, $password = null, $integrationCode = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setIntegrationCode($integrationCode);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetBarcode
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetBarcode
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get integrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->integrationCode;
    }
    /**
     * Set integrationCode value
     * @param string $integrationCode
     * @return \StructType\GetBarcode
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrationCode)), __LINE__);
        }
        $this->integrationCode = $integrationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
