<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BarcodeResult
 * @subpackage Structs
 */
class BarcodeResult extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCode;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBase64Binary
     */
    public $Images;
    /**
     * The ZebraZpl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ZebraZpl;
    /**
     * The ZebraEpl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ZebraEpl;
    /**
     * The BarcodeModelLst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBarcodeModel
     */
    public $BarcodeModelLst;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for BarcodeResult
     * @uses BarcodeResult::setResultCode()
     * @uses BarcodeResult::setImages()
     * @uses BarcodeResult::setZebraZpl()
     * @uses BarcodeResult::setZebraEpl()
     * @uses BarcodeResult::setBarcodeModelLst()
     * @uses BarcodeResult::setMessage()
     * @param int $resultCode
     * @param \ArrayType\ArrayOfBase64Binary $images
     * @param \ArrayType\ArrayOfString $zebraZpl
     * @param \ArrayType\ArrayOfString $zebraEpl
     * @param \ArrayType\ArrayOfBarcodeModel $barcodeModelLst
     * @param string $message
     */
    public function __construct($resultCode = null, \ArrayType\ArrayOfBase64Binary $images = null, \ArrayType\ArrayOfString $zebraZpl = null, \ArrayType\ArrayOfString $zebraEpl = null, \ArrayType\ArrayOfBarcodeModel $barcodeModelLst = null, $message = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setImages($images)
            ->setZebraZpl($zebraZpl)
            ->setZebraEpl($zebraEpl)
            ->setBarcodeModelLst($barcodeModelLst)
            ->setMessage($message);
    }
    /**
     * Get ResultCode value
     * @return int
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\BarcodeResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfBase64Binary|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfBase64Binary $images
     * @return \StructType\BarcodeResult
     */
    public function setImages(\ArrayType\ArrayOfBase64Binary $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ZebraZpl value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getZebraZpl()
    {
        return $this->ZebraZpl;
    }
    /**
     * Set ZebraZpl value
     * @param \ArrayType\ArrayOfString $zebraZpl
     * @return \StructType\BarcodeResult
     */
    public function setZebraZpl(\ArrayType\ArrayOfString $zebraZpl = null)
    {
        $this->ZebraZpl = $zebraZpl;
        return $this;
    }
    /**
     * Get ZebraEpl value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getZebraEpl()
    {
        return $this->ZebraEpl;
    }
    /**
     * Set ZebraEpl value
     * @param \ArrayType\ArrayOfString $zebraEpl
     * @return \StructType\BarcodeResult
     */
    public function setZebraEpl(\ArrayType\ArrayOfString $zebraEpl = null)
    {
        $this->ZebraEpl = $zebraEpl;
        return $this;
    }
    /**
     * Get BarcodeModelLst value
     * @return \ArrayType\ArrayOfBarcodeModel|null
     */
    public function getBarcodeModelLst()
    {
        return $this->BarcodeModelLst;
    }
    /**
     * Set BarcodeModelLst value
     * @param \ArrayType\ArrayOfBarcodeModel $barcodeModelLst
     * @return \StructType\BarcodeResult
     */
    public function setBarcodeModelLst(\ArrayType\ArrayOfBarcodeModel $barcodeModelLst = null)
    {
        $this->BarcodeModelLst = $barcodeModelLst;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BarcodeResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BarcodeResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
