<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetMeasurementSimulation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMeasurementSimulation $parameters
     * @return \StructType\SetMeasurementSimulationResponse|bool
     */
    public function SetMeasurementSimulation(\StructType\SetMeasurementSimulation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetMeasurementSimulation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCargoLineInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCargoLineInfo $parameters
     * @return \StructType\SetCargoLineInfoResponse|bool
     */
    public function SetCargoLineInfo(\StructType\SetCargoLineInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCargoLineInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSortedBag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSortedBag $parameters
     * @return \StructType\SetSortedBagResponse|bool
     */
    public function SetSortedBag(\StructType\SetSortedBag $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetSortedBag($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSortedBag2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSortedBag2 $parameters
     * @return \StructType\SetSortedBag2Response|bool
     */
    public function SetSortedBag2(\StructType\SetSortedBag2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetSortedBag2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSortedBag3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSortedBag3 $parameters
     * @return \StructType\SetSortedBag3Response|bool
     */
    public function SetSortedBag3(\StructType\SetSortedBag3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetSortedBag3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDispatchXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDispatchXML $parameters
     * @return \StructType\SetDispatchXMLResponse|bool
     */
    public function SetDispatchXML(\StructType\SetDispatchXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetDispatchXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDispatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDispatch $parameters
     * @return \StructType\SetDispatchResponse|bool
     */
    public function SetDispatch(\StructType\SetDispatch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetDispatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderPiece
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderPiece $parameters
     * @return \StructType\SetOrderPieceResponse|bool
     */
    public function SetOrderPiece(\StructType\SetOrderPiece $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetOrderPiece($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrder $parameters
     * @return \StructType\SetOrderResponse|bool
     */
    public function SetOrder(\StructType\SetOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAddress $parameters
     * @return \StructType\SetAddressResponse|bool
     */
    public function SetAddress(\StructType\SetAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCanceledShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCanceledShipment $parameters
     * @return \StructType\SetCanceledShipmentResponse|bool
     */
    public function SetCanceledShipment(\StructType\SetCanceledShipment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCanceledShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetAddressResponse|\StructType\SetCanceledShipmentResponse|\StructType\SetCargoLineInfoResponse|\StructType\SetDispatchResponse|\StructType\SetDispatchXMLResponse|\StructType\SetMeasurementSimulationResponse|\StructType\SetOrderPieceResponse|\StructType\SetOrderResponse|\StructType\SetSortedBag2Response|\StructType\SetSortedBag3Response|\StructType\SetSortedBagResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
