<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPiece ArrayType
 * @subpackage Arrays
 */
class ArrayOfPiece extends AbstractStructArrayBase
{
    /**
     * The Piece
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Piece[]
     */
    public $Piece;
    /**
     * Constructor method for ArrayOfPiece
     * @uses ArrayOfPiece::setPiece()
     * @param \StructType\Piece[] $piece
     */
    public function __construct(array $piece = array())
    {
        $this
            ->setPiece($piece);
    }
    /**
     * Get Piece value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Piece[]|null
     */
    public function getPiece()
    {
        return isset($this->Piece) ? $this->Piece : null;
    }
    /**
     * Set Piece value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Piece[] $piece
     * @return \ArrayType\ArrayOfPiece
     */
    public function setPiece(array $piece = array())
    {
        foreach ($piece as $arrayOfPiecePieceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPiecePieceItem instanceof \StructType\Piece) {
                throw new \InvalidArgumentException(sprintf('The Piece property can only contain items of \StructType\Piece, "%s" given', is_object($arrayOfPiecePieceItem) ? get_class($arrayOfPiecePieceItem) : gettype($arrayOfPiecePieceItem)), __LINE__);
            }
        }
        if (is_null($piece) || (is_array($piece) && empty($piece))) {
            unset($this->Piece);
        } else {
            $this->Piece = $piece;
        }
        return $this;
    }
    /**
     * Add item to Piece value
     * @throws \InvalidArgumentException
     * @param \StructType\Piece $item
     * @return \ArrayType\ArrayOfPiece
     */
    public function addToPiece(\StructType\Piece $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Piece) {
            throw new \InvalidArgumentException(sprintf('The Piece property can only contain items of \StructType\Piece, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Piece[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Piece|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Piece|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Piece|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Piece|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Piece|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Piece
     */
    public function getAttributeName()
    {
        return 'Piece';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPiece
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
