<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBarcodeModel ArrayType
 * @subpackage Arrays
 */
class ArrayOfBarcodeModel extends AbstractStructArrayBase
{
    /**
     * The BarcodeModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BarcodeModel[]
     */
    public $BarcodeModel;
    /**
     * Constructor method for ArrayOfBarcodeModel
     * @uses ArrayOfBarcodeModel::setBarcodeModel()
     * @param \StructType\BarcodeModel[] $barcodeModel
     */
    public function __construct(array $barcodeModel = array())
    {
        $this
            ->setBarcodeModel($barcodeModel);
    }
    /**
     * Get BarcodeModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BarcodeModel[]|null
     */
    public function getBarcodeModel()
    {
        return isset($this->BarcodeModel) ? $this->BarcodeModel : null;
    }
    /**
     * Set BarcodeModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BarcodeModel[] $barcodeModel
     * @return \ArrayType\ArrayOfBarcodeModel
     */
    public function setBarcodeModel(array $barcodeModel = array())
    {
        foreach ($barcodeModel as $arrayOfBarcodeModelBarcodeModelItem) {
            // validation for constraint: itemType
            if (!$arrayOfBarcodeModelBarcodeModelItem instanceof \StructType\BarcodeModel) {
                throw new \InvalidArgumentException(sprintf('The BarcodeModel property can only contain items of \StructType\BarcodeModel, "%s" given', is_object($arrayOfBarcodeModelBarcodeModelItem) ? get_class($arrayOfBarcodeModelBarcodeModelItem) : gettype($arrayOfBarcodeModelBarcodeModelItem)), __LINE__);
            }
        }
        if (is_null($barcodeModel) || (is_array($barcodeModel) && empty($barcodeModel))) {
            unset($this->BarcodeModel);
        } else {
            $this->BarcodeModel = $barcodeModel;
        }
        return $this;
    }
    /**
     * Add item to BarcodeModel value
     * @throws \InvalidArgumentException
     * @param \StructType\BarcodeModel $item
     * @return \ArrayType\ArrayOfBarcodeModel
     */
    public function addToBarcodeModel(\StructType\BarcodeModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BarcodeModel) {
            throw new \InvalidArgumentException(sprintf('The BarcodeModel property can only contain items of \StructType\BarcodeModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BarcodeModel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BarcodeModel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BarcodeModel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BarcodeModel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BarcodeModel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BarcodeModel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BarcodeModel
     */
    public function getAttributeName()
    {
        return 'BarcodeModel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBarcodeModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
