<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA5 StructType
 * @subpackage Structs
 */
class WEBCARGODATA5 extends AbstractStructBase
{
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The ADDRESS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 256
     * @var string
     */
    public $ADDRESS;
    /**
     * The ILCE
     * Meta informations extracted from the WSDL
     * - maxLength: 64
     * @var string
     */
    public $ILCE;
    /**
     * The TELEFON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $TELEFON;
    /**
     * The EMAIL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $EMAIL;
    /**
     * The BAGLI_BOLGE
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $BAGLI_BOLGE;
    /**
     * The KORDINAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $KORDINAT;
    /**
     * The SUBE_ID
     * @var float
     */
    public $SUBE_ID;
    /**
     * Constructor method for WEBCARGODATA5
     * @uses WEBCARGODATA5::setNAME()
     * @uses WEBCARGODATA5::setADDRESS()
     * @uses WEBCARGODATA5::setILCE()
     * @uses WEBCARGODATA5::setTELEFON()
     * @uses WEBCARGODATA5::setEMAIL()
     * @uses WEBCARGODATA5::setBAGLI_BOLGE()
     * @uses WEBCARGODATA5::setKORDINAT()
     * @uses WEBCARGODATA5::setSUBE_ID()
     * @param string $nAME
     * @param string $aDDRESS
     * @param string $iLCE
     * @param string $tELEFON
     * @param string $eMAIL
     * @param string $bAGLI_BOLGE
     * @param string $kORDINAT
     * @param float $sUBE_ID
     */
    public function __construct($nAME = null, $aDDRESS = null, $iLCE = null, $tELEFON = null, $eMAIL = null, $bAGLI_BOLGE = null, $kORDINAT = null, $sUBE_ID = null)
    {
        $this
            ->setNAME($nAME)
            ->setADDRESS($aDDRESS)
            ->setILCE($iLCE)
            ->setTELEFON($tELEFON)
            ->setEMAIL($eMAIL)
            ->setBAGLI_BOLGE($bAGLI_BOLGE)
            ->setKORDINAT($kORDINAT)
            ->setSUBE_ID($sUBE_ID);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\WEBCARGODATA5
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \StructType\WEBCARGODATA5
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aDDRESS) && strlen($aDDRESS) > 256) || (is_array($aDDRESS) && count($aDDRESS) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($aDDRESS) ? strlen($aDDRESS) : count($aDDRESS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get ILCE value
     * @return string|null
     */
    public function getILCE()
    {
        return $this->ILCE;
    }
    /**
     * Set ILCE value
     * @param string $iLCE
     * @return \StructType\WEBCARGODATA5
     */
    public function setILCE($iLCE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iLCE) && strlen($iLCE) > 64) || (is_array($iLCE) && count($iLCE) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($iLCE) ? strlen($iLCE) : count($iLCE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iLCE) && !is_string($iLCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iLCE)), __LINE__);
        }
        $this->ILCE = $iLCE;
        return $this;
    }
    /**
     * Get TELEFON value
     * @return string|null
     */
    public function getTELEFON()
    {
        return $this->TELEFON;
    }
    /**
     * Set TELEFON value
     * @param string $tELEFON
     * @return \StructType\WEBCARGODATA5
     */
    public function setTELEFON($tELEFON = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tELEFON) && strlen($tELEFON) > 32) || (is_array($tELEFON) && count($tELEFON) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($tELEFON) ? strlen($tELEFON) : count($tELEFON)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tELEFON) && !is_string($tELEFON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tELEFON)), __LINE__);
        }
        $this->TELEFON = $tELEFON;
        return $this;
    }
    /**
     * Get EMAIL value
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }
    /**
     * Set EMAIL value
     * @param string $eMAIL
     * @return \StructType\WEBCARGODATA5
     */
    public function setEMAIL($eMAIL = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eMAIL) && strlen($eMAIL) > 128) || (is_array($eMAIL) && count($eMAIL) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($eMAIL) ? strlen($eMAIL) : count($eMAIL)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eMAIL) && !is_string($eMAIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL)), __LINE__);
        }
        $this->EMAIL = $eMAIL;
        return $this;
    }
    /**
     * Get BAGLI_BOLGE value
     * @return string|null
     */
    public function getBAGLI_BOLGE()
    {
        return $this->BAGLI_BOLGE;
    }
    /**
     * Set BAGLI_BOLGE value
     * @param string $bAGLI_BOLGE
     * @return \StructType\WEBCARGODATA5
     */
    public function setBAGLI_BOLGE($bAGLI_BOLGE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bAGLI_BOLGE) && strlen($bAGLI_BOLGE) > 32) || (is_array($bAGLI_BOLGE) && count($bAGLI_BOLGE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($bAGLI_BOLGE) ? strlen($bAGLI_BOLGE) : count($bAGLI_BOLGE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bAGLI_BOLGE) && !is_string($bAGLI_BOLGE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bAGLI_BOLGE)), __LINE__);
        }
        $this->BAGLI_BOLGE = $bAGLI_BOLGE;
        return $this;
    }
    /**
     * Get KORDINAT value
     * @return string|null
     */
    public function getKORDINAT()
    {
        return $this->KORDINAT;
    }
    /**
     * Set KORDINAT value
     * @param string $kORDINAT
     * @return \StructType\WEBCARGODATA5
     */
    public function setKORDINAT($kORDINAT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kORDINAT) && strlen($kORDINAT) > 32) || (is_array($kORDINAT) && count($kORDINAT) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($kORDINAT) ? strlen($kORDINAT) : count($kORDINAT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kORDINAT) && !is_string($kORDINAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kORDINAT)), __LINE__);
        }
        $this->KORDINAT = $kORDINAT;
        return $this;
    }
    /**
     * Get SUBE_ID value
     * @return float|null
     */
    public function getSUBE_ID()
    {
        return $this->SUBE_ID;
    }
    /**
     * Set SUBE_ID value
     * @param float $sUBE_ID
     * @return \StructType\WEBCARGODATA5
     */
    public function setSUBE_ID($sUBE_ID = null)
    {
        $this->SUBE_ID = $sUBE_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WEBCARGODATA5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
