<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA2 StructType
 * @subpackage Structs
 */
class WEBCARGODATA2 extends AbstractStructBase
{
    /**
     * The MUSTERI_KODU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MUSTERI_KODU;
    /**
     * The SERI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $SERI;
    /**
     * The IRSNO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $IRSNO;
    /**
     * The REFNO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $REFNO;
    /**
     * The IRSNO1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $IRSNO1;
    /**
     * The MOK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MOK;
    /**
     * The OT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $OT;
    /**
     * The TARIH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 19
     * @var string
     */
    public $TARIH;
    /**
     * The CIKIS_SUBESI
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIS_SUBESI
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The SEHIR
     * Meta informations extracted from the WSDL
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The TUTAR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The ADET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The DESI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The TESLIM_ALAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_TARIHI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TESLIM_SAATI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The IADE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $IADE;
    /**
     * Constructor method for WEBCARGODATA2
     * @uses WEBCARGODATA2::setMUSTERI_KODU()
     * @uses WEBCARGODATA2::setSERI()
     * @uses WEBCARGODATA2::setIRSNO()
     * @uses WEBCARGODATA2::setREFNO()
     * @uses WEBCARGODATA2::setIRSNO1()
     * @uses WEBCARGODATA2::setMOK()
     * @uses WEBCARGODATA2::setOT()
     * @uses WEBCARGODATA2::setTARIH()
     * @uses WEBCARGODATA2::setCIKIS_SUBESI()
     * @uses WEBCARGODATA2::setVARIS_SUBESI()
     * @uses WEBCARGODATA2::setALICI_ADI()
     * @uses WEBCARGODATA2::setSEHIR()
     * @uses WEBCARGODATA2::setTUTAR()
     * @uses WEBCARGODATA2::setADET()
     * @uses WEBCARGODATA2::setDESI()
     * @uses WEBCARGODATA2::setTESLIM_ALAN()
     * @uses WEBCARGODATA2::setTESLIM_TARIHI()
     * @uses WEBCARGODATA2::setTESLIM_SAATI()
     * @uses WEBCARGODATA2::setIADE()
     * @param string $mUSTERI_KODU
     * @param string $sERI
     * @param string $iRSNO
     * @param string $rEFNO
     * @param string $iRSNO1
     * @param string $mOK
     * @param string $oT
     * @param string $tARIH
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param float $tUTAR
     * @param float $aDET
     * @param float $dESI
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_TARIHI
     * @param string $tESLIM_SAATI
     * @param string $iADE
     */
    public function __construct($mUSTERI_KODU = null, $sERI = null, $iRSNO = null, $rEFNO = null, $iRSNO1 = null, $mOK = null, $oT = null, $tARIH = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $tUTAR = null, $aDET = null, $dESI = null, $tESLIM_ALAN = null, $tESLIM_TARIHI = null, $tESLIM_SAATI = null, $iADE = null)
    {
        $this
            ->setMUSTERI_KODU($mUSTERI_KODU)
            ->setSERI($sERI)
            ->setIRSNO($iRSNO)
            ->setREFNO($rEFNO)
            ->setIRSNO1($iRSNO1)
            ->setMOK($mOK)
            ->setOT($oT)
            ->setTARIH($tARIH)
            ->setCIKIS_SUBESI($cIKIS_SUBESI)
            ->setVARIS_SUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setTUTAR($tUTAR)
            ->setADET($aDET)
            ->setDESI($dESI)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setIADE($iADE);
    }
    /**
     * Get MUSTERI_KODU value
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }
    /**
     * Set MUSTERI_KODU value
     * @param string $mUSTERI_KODU
     * @return \StructType\WEBCARGODATA2
     */
    public function setMUSTERI_KODU($mUSTERI_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mUSTERI_KODU) && strlen($mUSTERI_KODU) > 32) || (is_array($mUSTERI_KODU) && count($mUSTERI_KODU) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mUSTERI_KODU) ? strlen($mUSTERI_KODU) : count($mUSTERI_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mUSTERI_KODU) && !is_string($mUSTERI_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mUSTERI_KODU)), __LINE__);
        }
        $this->MUSTERI_KODU = $mUSTERI_KODU;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \StructType\WEBCARGODATA2
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sERI) && strlen($sERI) > 2) || (is_array($sERI) && count($sERI) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($sERI) ? strlen($sERI) : count($sERI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get IRSNO value
     * @return string|null
     */
    public function getIRSNO()
    {
        return $this->IRSNO;
    }
    /**
     * Set IRSNO value
     * @param string $iRSNO
     * @return \StructType\WEBCARGODATA2
     */
    public function setIRSNO($iRSNO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iRSNO) && strlen($iRSNO) > 8) || (is_array($iRSNO) && count($iRSNO) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iRSNO) ? strlen($iRSNO) : count($iRSNO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iRSNO) && !is_string($iRSNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSNO)), __LINE__);
        }
        $this->IRSNO = $iRSNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \StructType\WEBCARGODATA2
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rEFNO) && strlen($rEFNO) > 16) || (is_array($rEFNO) && count($rEFNO) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($rEFNO) ? strlen($rEFNO) : count($rEFNO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get IRSNO1 value
     * @return string|null
     */
    public function getIRSNO1()
    {
        return $this->IRSNO1;
    }
    /**
     * Set IRSNO1 value
     * @param string $iRSNO1
     * @return \StructType\WEBCARGODATA2
     */
    public function setIRSNO1($iRSNO1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iRSNO1) && strlen($iRSNO1) > 16) || (is_array($iRSNO1) && count($iRSNO1) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($iRSNO1) ? strlen($iRSNO1) : count($iRSNO1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iRSNO1) && !is_string($iRSNO1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSNO1)), __LINE__);
        }
        $this->IRSNO1 = $iRSNO1;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \StructType\WEBCARGODATA2
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mOK) && strlen($mOK) > 32) || (is_array($mOK) && count($mOK) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mOK) ? strlen($mOK) : count($mOK)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get OT value
     * @return string|null
     */
    public function getOT()
    {
        return $this->OT;
    }
    /**
     * Set OT value
     * @param string $oT
     * @return \StructType\WEBCARGODATA2
     */
    public function setOT($oT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oT) && strlen($oT) > 2) || (is_array($oT) && count($oT) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($oT) ? strlen($oT) : count($oT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oT) && !is_string($oT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oT)), __LINE__);
        }
        $this->OT = $oT;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \StructType\WEBCARGODATA2
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tARIH) && strlen($tARIH) > 19) || (is_array($tARIH) && count($tARIH) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($tARIH) ? strlen($tARIH) : count($tARIH)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Get CIKIS_SUBESI value
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set CIKIS_SUBESI value
     * @param string $cIKIS_SUBESI
     * @return \StructType\WEBCARGODATA2
     */
    public function setCIKIS_SUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_SUBESI) && strlen($cIKIS_SUBESI) > 32) || (is_array($cIKIS_SUBESI) && count($cIKIS_SUBESI) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($cIKIS_SUBESI) ? strlen($cIKIS_SUBESI) : count($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIS_SUBESI value
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIS_SUBESI value
     * @param string $vARIS_SUBESI
     * @return \StructType\WEBCARGODATA2
     */
    public function setVARIS_SUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_SUBESI) && strlen($vARIS_SUBESI) > 32) || (is_array($vARIS_SUBESI) && count($vARIS_SUBESI) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($vARIS_SUBESI) ? strlen($vARIS_SUBESI) : count($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \StructType\WEBCARGODATA2
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aLICI_ADI) && strlen($aLICI_ADI) > 128) || (is_array($aLICI_ADI) && count($aLICI_ADI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aLICI_ADI) ? strlen($aLICI_ADI) : count($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get SEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set SEHIR value
     * @param string $sEHIR
     * @return \StructType\WEBCARGODATA2
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sEHIR) && strlen($sEHIR) > 64) || (is_array($sEHIR) && count($sEHIR) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($sEHIR) ? strlen($sEHIR) : count($sEHIR)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \StructType\WEBCARGODATA2
     */
    public function setTUTAR($tUTAR = null)
    {
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \StructType\WEBCARGODATA2
     */
    public function setADET($aDET = null)
    {
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \StructType\WEBCARGODATA2
     */
    public function setDESI($dESI = null)
    {
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \StructType\WEBCARGODATA2
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_ALAN) && strlen($tESLIM_ALAN) > 128) || (is_array($tESLIM_ALAN) && count($tESLIM_ALAN) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($tESLIM_ALAN) ? strlen($tESLIM_ALAN) : count($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \StructType\WEBCARGODATA2
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_TARIHI) && strlen($tESLIM_TARIHI) > 10) || (is_array($tESLIM_TARIHI) && count($tESLIM_TARIHI) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($tESLIM_TARIHI) ? strlen($tESLIM_TARIHI) : count($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \StructType\WEBCARGODATA2
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tESLIM_SAATI) && strlen($tESLIM_SAATI) > 8) || (is_array($tESLIM_SAATI) && count($tESLIM_SAATI) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($tESLIM_SAATI) ? strlen($tESLIM_SAATI) : count($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get IADE value
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }
    /**
     * Set IADE value
     * @param string $iADE
     * @return \StructType\WEBCARGODATA2
     */
    public function setIADE($iADE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iADE) && strlen($iADE) > 5) || (is_array($iADE) && count($iADE) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($iADE) ? strlen($iADE) : count($iADE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iADE) && !is_string($iADE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iADE)), __LINE__);
        }
        $this->IADE = $iADE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WEBCARGODATA2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
