<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentSortInfo StructType
 * @subpackage Structs
 */
class ShipmentSortInfo extends AbstractStructBase
{
    /**
     * The DOCUMENT_NUMBER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $DOCUMENT_NUMBER;
    /**
     * The DELIVERY_UNIT_NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $DELIVERY_UNIT_NAME;
    /**
     * The CARGO_TYPE
     * @var string
     */
    public $CARGO_TYPE;
    /**
     * The AMOUNT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 81
     * @var string
     */
    public $AMOUNT;
    /**
     * The SENDERNAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $SENDERNAME;
    /**
     * The RECEIVERNAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $RECEIVERNAME;
    /**
     * The RECEIVER_ADDRESS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 129
     * @var string
     */
    public $RECEIVER_ADDRESS;
    /**
     * The PRICE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PRICE;
    /**
     * The SHIPMENT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $SHIPMENT_CODE;
    /**
     * Constructor method for ShipmentSortInfo
     * @uses ShipmentSortInfo::setDOCUMENT_NUMBER()
     * @uses ShipmentSortInfo::setDELIVERY_UNIT_NAME()
     * @uses ShipmentSortInfo::setCARGO_TYPE()
     * @uses ShipmentSortInfo::setAMOUNT()
     * @uses ShipmentSortInfo::setSENDERNAME()
     * @uses ShipmentSortInfo::setRECEIVERNAME()
     * @uses ShipmentSortInfo::setRECEIVER_ADDRESS()
     * @uses ShipmentSortInfo::setPRICE()
     * @uses ShipmentSortInfo::setSHIPMENT_CODE()
     * @param string $dOCUMENT_NUMBER
     * @param string $dELIVERY_UNIT_NAME
     * @param string $cARGO_TYPE
     * @param string $aMOUNT
     * @param string $sENDERNAME
     * @param string $rECEIVERNAME
     * @param string $rECEIVER_ADDRESS
     * @param float $pRICE
     * @param string $sHIPMENT_CODE
     */
    public function __construct($dOCUMENT_NUMBER = null, $dELIVERY_UNIT_NAME = null, $cARGO_TYPE = null, $aMOUNT = null, $sENDERNAME = null, $rECEIVERNAME = null, $rECEIVER_ADDRESS = null, $pRICE = null, $sHIPMENT_CODE = null)
    {
        $this
            ->setDOCUMENT_NUMBER($dOCUMENT_NUMBER)
            ->setDELIVERY_UNIT_NAME($dELIVERY_UNIT_NAME)
            ->setCARGO_TYPE($cARGO_TYPE)
            ->setAMOUNT($aMOUNT)
            ->setSENDERNAME($sENDERNAME)
            ->setRECEIVERNAME($rECEIVERNAME)
            ->setRECEIVER_ADDRESS($rECEIVER_ADDRESS)
            ->setPRICE($pRICE)
            ->setSHIPMENT_CODE($sHIPMENT_CODE);
    }
    /**
     * Get DOCUMENT_NUMBER value
     * @return string|null
     */
    public function getDOCUMENT_NUMBER()
    {
        return $this->DOCUMENT_NUMBER;
    }
    /**
     * Set DOCUMENT_NUMBER value
     * @param string $dOCUMENT_NUMBER
     * @return \StructType\ShipmentSortInfo
     */
    public function setDOCUMENT_NUMBER($dOCUMENT_NUMBER = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dOCUMENT_NUMBER) && strlen($dOCUMENT_NUMBER) > 8) || (is_array($dOCUMENT_NUMBER) && count($dOCUMENT_NUMBER) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($dOCUMENT_NUMBER) ? strlen($dOCUMENT_NUMBER) : count($dOCUMENT_NUMBER)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dOCUMENT_NUMBER) && !is_string($dOCUMENT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOCUMENT_NUMBER)), __LINE__);
        }
        $this->DOCUMENT_NUMBER = $dOCUMENT_NUMBER;
        return $this;
    }
    /**
     * Get DELIVERY_UNIT_NAME value
     * @return string|null
     */
    public function getDELIVERY_UNIT_NAME()
    {
        return $this->DELIVERY_UNIT_NAME;
    }
    /**
     * Set DELIVERY_UNIT_NAME value
     * @param string $dELIVERY_UNIT_NAME
     * @return \StructType\ShipmentSortInfo
     */
    public function setDELIVERY_UNIT_NAME($dELIVERY_UNIT_NAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dELIVERY_UNIT_NAME) && strlen($dELIVERY_UNIT_NAME) > 32) || (is_array($dELIVERY_UNIT_NAME) && count($dELIVERY_UNIT_NAME) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($dELIVERY_UNIT_NAME) ? strlen($dELIVERY_UNIT_NAME) : count($dELIVERY_UNIT_NAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dELIVERY_UNIT_NAME) && !is_string($dELIVERY_UNIT_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dELIVERY_UNIT_NAME)), __LINE__);
        }
        $this->DELIVERY_UNIT_NAME = $dELIVERY_UNIT_NAME;
        return $this;
    }
    /**
     * Get CARGO_TYPE value
     * @return string|null
     */
    public function getCARGO_TYPE()
    {
        return $this->CARGO_TYPE;
    }
    /**
     * Set CARGO_TYPE value
     * @param string $cARGO_TYPE
     * @return \StructType\ShipmentSortInfo
     */
    public function setCARGO_TYPE($cARGO_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($cARGO_TYPE) && !is_string($cARGO_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cARGO_TYPE)), __LINE__);
        }
        $this->CARGO_TYPE = $cARGO_TYPE;
        return $this;
    }
    /**
     * Get AMOUNT value
     * @return string|null
     */
    public function getAMOUNT()
    {
        return $this->AMOUNT;
    }
    /**
     * Set AMOUNT value
     * @param string $aMOUNT
     * @return \StructType\ShipmentSortInfo
     */
    public function setAMOUNT($aMOUNT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aMOUNT) && strlen($aMOUNT) > 81) || (is_array($aMOUNT) && count($aMOUNT) > 81)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 81 element(s) or a scalar of 81 character(s) at most, "%d" length given', is_scalar($aMOUNT) ? strlen($aMOUNT) : count($aMOUNT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aMOUNT) && !is_string($aMOUNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMOUNT)), __LINE__);
        }
        $this->AMOUNT = $aMOUNT;
        return $this;
    }
    /**
     * Get SENDERNAME value
     * @return string|null
     */
    public function getSENDERNAME()
    {
        return $this->SENDERNAME;
    }
    /**
     * Set SENDERNAME value
     * @param string $sENDERNAME
     * @return \StructType\ShipmentSortInfo
     */
    public function setSENDERNAME($sENDERNAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sENDERNAME) && strlen($sENDERNAME) > 128) || (is_array($sENDERNAME) && count($sENDERNAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($sENDERNAME) ? strlen($sENDERNAME) : count($sENDERNAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sENDERNAME) && !is_string($sENDERNAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sENDERNAME)), __LINE__);
        }
        $this->SENDERNAME = $sENDERNAME;
        return $this;
    }
    /**
     * Get RECEIVERNAME value
     * @return string|null
     */
    public function getRECEIVERNAME()
    {
        return $this->RECEIVERNAME;
    }
    /**
     * Set RECEIVERNAME value
     * @param string $rECEIVERNAME
     * @return \StructType\ShipmentSortInfo
     */
    public function setRECEIVERNAME($rECEIVERNAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rECEIVERNAME) && strlen($rECEIVERNAME) > 128) || (is_array($rECEIVERNAME) && count($rECEIVERNAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($rECEIVERNAME) ? strlen($rECEIVERNAME) : count($rECEIVERNAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rECEIVERNAME) && !is_string($rECEIVERNAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rECEIVERNAME)), __LINE__);
        }
        $this->RECEIVERNAME = $rECEIVERNAME;
        return $this;
    }
    /**
     * Get RECEIVER_ADDRESS value
     * @return string|null
     */
    public function getRECEIVER_ADDRESS()
    {
        return $this->RECEIVER_ADDRESS;
    }
    /**
     * Set RECEIVER_ADDRESS value
     * @param string $rECEIVER_ADDRESS
     * @return \StructType\ShipmentSortInfo
     */
    public function setRECEIVER_ADDRESS($rECEIVER_ADDRESS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rECEIVER_ADDRESS) && strlen($rECEIVER_ADDRESS) > 129) || (is_array($rECEIVER_ADDRESS) && count($rECEIVER_ADDRESS) > 129)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 129 element(s) or a scalar of 129 character(s) at most, "%d" length given', is_scalar($rECEIVER_ADDRESS) ? strlen($rECEIVER_ADDRESS) : count($rECEIVER_ADDRESS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rECEIVER_ADDRESS) && !is_string($rECEIVER_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rECEIVER_ADDRESS)), __LINE__);
        }
        $this->RECEIVER_ADDRESS = $rECEIVER_ADDRESS;
        return $this;
    }
    /**
     * Get PRICE value
     * @return float|null
     */
    public function getPRICE()
    {
        return $this->PRICE;
    }
    /**
     * Set PRICE value
     * @param float $pRICE
     * @return \StructType\ShipmentSortInfo
     */
    public function setPRICE($pRICE = null)
    {
        $this->PRICE = $pRICE;
        return $this;
    }
    /**
     * Get SHIPMENT_CODE value
     * @return string|null
     */
    public function getSHIPMENT_CODE()
    {
        return $this->SHIPMENT_CODE;
    }
    /**
     * Set SHIPMENT_CODE value
     * @param string $sHIPMENT_CODE
     * @return \StructType\ShipmentSortInfo
     */
    public function setSHIPMENT_CODE($sHIPMENT_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sHIPMENT_CODE) && strlen($sHIPMENT_CODE) > 32) || (is_array($sHIPMENT_CODE) && count($sHIPMENT_CODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($sHIPMENT_CODE) ? strlen($sHIPMENT_CODE) : count($sHIPMENT_CODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sHIPMENT_CODE) && !is_string($sHIPMENT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sHIPMENT_CODE)), __LINE__);
        }
        $this->SHIPMENT_CODE = $sHIPMENT_CODE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentSortInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
