<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrder StructType
 * @subpackage Structs
 */
class SetOrder extends AbstractStructBase
{
    /**
     * The orderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrder
     */
    public $orderInfo;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for SetOrder
     * @uses SetOrder::setOrderInfo()
     * @uses SetOrder::setUserName()
     * @uses SetOrder::setPassword()
     * @param \ArrayType\ArrayOfOrder $orderInfo
     * @param string $userName
     * @param string $password
     */
    public function __construct(\ArrayType\ArrayOfOrder $orderInfo = null, $userName = null, $password = null)
    {
        $this
            ->setOrderInfo($orderInfo)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get orderInfo value
     * @return \ArrayType\ArrayOfOrder|null
     */
    public function getOrderInfo()
    {
        return $this->orderInfo;
    }
    /**
     * Set orderInfo value
     * @param \ArrayType\ArrayOfOrder $orderInfo
     * @return \StructType\SetOrder
     */
    public function setOrderInfo(\ArrayType\ArrayOfOrder $orderInfo = null)
    {
        $this->orderInfo = $orderInfo;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\SetOrder
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetOrder
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
