<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCanceledShipment StructType
 * @subpackage Structs
 */
class SetCanceledShipment extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The cargoKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $cargoKey;
    /**
     * The canceledDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $canceledDescription;
    /**
     * Constructor method for SetCanceledShipment
     * @uses SetCanceledShipment::setUserName()
     * @uses SetCanceledShipment::setPassword()
     * @uses SetCanceledShipment::setLanguage()
     * @uses SetCanceledShipment::setCargoKey()
     * @uses SetCanceledShipment::setCanceledDescription()
     * @param string $userName
     * @param string $password
     * @param string $language
     * @param \ArrayType\ArrayOfString $cargoKey
     * @param string $canceledDescription
     */
    public function __construct($userName = null, $password = null, $language = null, \ArrayType\ArrayOfString $cargoKey = null, $canceledDescription = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setLanguage($language)
            ->setCargoKey($cargoKey)
            ->setCanceledDescription($canceledDescription);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\SetCanceledShipment
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetCanceledShipment
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\SetCanceledShipment
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get cargoKey value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCargoKey()
    {
        return $this->cargoKey;
    }
    /**
     * Set cargoKey value
     * @param \ArrayType\ArrayOfString $cargoKey
     * @return \StructType\SetCanceledShipment
     */
    public function setCargoKey(\ArrayType\ArrayOfString $cargoKey = null)
    {
        $this->cargoKey = $cargoKey;
        return $this;
    }
    /**
     * Get canceledDescription value
     * @return string|null
     */
    public function getCanceledDescription()
    {
        return $this->canceledDescription;
    }
    /**
     * Set canceledDescription value
     * @param string $canceledDescription
     * @return \StructType\SetCanceledShipment
     */
    public function setCanceledDescription($canceledDescription = null)
    {
        // validation for constraint: string
        if (!is_null($canceledDescription) && !is_string($canceledDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($canceledDescription)), __LINE__);
        }
        $this->canceledDescription = $canceledDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCanceledShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
