<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultMessage StructType
 * @subpackage Structs
 */
class ResultMessage extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AddressId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressId;
    /**
     * Constructor method for ResultMessage
     * @uses ResultMessage::setResultCode()
     * @uses ResultMessage::setMessage()
     * @uses ResultMessage::setAddressId()
     * @param string $resultCode
     * @param string $message
     * @param string $addressId
     */
    public function __construct($resultCode = null, $message = null, $addressId = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setMessage($message)
            ->setAddressId($addressId);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\ResultMessage
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\ResultMessage
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AddressId value
     * @return string|null
     */
    public function getAddressId()
    {
        return $this->AddressId;
    }
    /**
     * Set AddressId value
     * @param string $addressId
     * @return \StructType\ResultMessage
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: string
        if (!is_null($addressId) && !is_string($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressId)), __LINE__);
        }
        $this->AddressId = $addressId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
