<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceDetail StructType
 * @subpackage Structs
 */
class PieceDetail extends AbstractStructBase
{
    /**
     * The VolumetricWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumetricWeight;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The BarcodeNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeNumber;
    /**
     * The ProductNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductNumber;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PieceDetail
     * @uses PieceDetail::setVolumetricWeight()
     * @uses PieceDetail::setWeight()
     * @uses PieceDetail::setBarcodeNumber()
     * @uses PieceDetail::setProductNumber()
     * @uses PieceDetail::setDescription()
     * @param string $volumetricWeight
     * @param string $weight
     * @param string $barcodeNumber
     * @param string $productNumber
     * @param string $description
     */
    public function __construct($volumetricWeight = null, $weight = null, $barcodeNumber = null, $productNumber = null, $description = null)
    {
        $this
            ->setVolumetricWeight($volumetricWeight)
            ->setWeight($weight)
            ->setBarcodeNumber($barcodeNumber)
            ->setProductNumber($productNumber)
            ->setDescription($description);
    }
    /**
     * Get VolumetricWeight value
     * @return string|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param string $volumetricWeight
     * @return \StructType\PieceDetail
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: string
        if (!is_null($volumetricWeight) && !is_string($volumetricWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($volumetricWeight)), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\PieceDetail
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get BarcodeNumber value
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->BarcodeNumber;
    }
    /**
     * Set BarcodeNumber value
     * @param string $barcodeNumber
     * @return \StructType\PieceDetail
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeNumber)), __LINE__);
        }
        $this->BarcodeNumber = $barcodeNumber;
        return $this;
    }
    /**
     * Get ProductNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->ProductNumber;
    }
    /**
     * Set ProductNumber value
     * @param string $productNumber
     * @return \StructType\PieceDetail
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productNumber)), __LINE__);
        }
        $this->ProductNumber = $productNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PieceDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PieceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
